/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Structured;
import com.certicom.security.asn1.ASN1Type;
import java.util.Vector;

public abstract class ASN1SetOf
extends ASN1Structured {
    ASN1Type pattern;
    Vector set;

    public ASN1SetOf(ASN1Type aSN1Type) {
        this.pattern = aSN1Type;
        this.set = new Vector();
    }

    public byte typeTag() {
        return 17;
    }

    public int size() {
        return this.set.size();
    }

    public ASN1Type getItem(int n) {
        if (n < this.set.size()) {
            return (ASN1Type)this.set.elementAt(n);
        }
        return null;
    }

    public boolean addItem(ASN1Type aSN1Type) {
        if (aSN1Type.tag() == this.pattern.tag()) {
            this.set.addElement(aSN1Type);
            return true;
        }
        return false;
    }

    public boolean removeItem(int n) {
        if (n < this.set.size()) {
            this.set.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeSetOf(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeSetOf(this);
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.set = new Vector();
        if (aSN1InputStream.eof()) {
            return;
        }
        try {
            while (aSN1InputStream.peekTag() == this.pattern.tag()) {
                ASN1Type aSN1Type = (ASN1Type)this.pattern.getClass().newInstance();
                aSN1Type.decode(aSN1InputStream);
                this.set.addElement(aSN1Type);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ASN1ParsingException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ASN1ParsingException(illegalAccessException.getMessage());
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        for (int i = 0; i < this.set.size(); ++i) {
            ASN1Type aSN1Type = (ASN1Type)this.set.elementAt(i);
            aSN1Type.encode(aSN1OutputStream);
        }
    }
}

