/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1String;

public abstract class ASN1SimpleString
extends ASN1String {
    private String string = new String();

    public ASN1SimpleString() {
    }

    public ASN1SimpleString(byte[] byArray) throws ASN1ParsingException {
        this();
        this.setValue(byArray);
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeString(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeString(this);
    }

    public int length() {
        if (this.string == null) {
            return 0;
        }
        return this.string.length();
    }

    public String getString() {
        return this.string;
    }

    public void setValue(String string) throws ASN1ParsingException {
        byte[] byArray = this.convert(string);
        this.setValue(byArray);
    }

    public void setValue(byte[] byArray) throws ASN1ParsingException {
        if (byArray == null) {
            throw new NullPointerException(Resources.getMessage("196"));
        }
        this.string = this.convert(byArray);
        if (this.string == null) {
            throw new ASN1ParsingException(Resources.getMessage("197"));
        }
    }

    public byte[] toByteArray() {
        return this.convert(this.string);
    }

    void setBufferTo(byte[] byArray) throws ASN1ParsingException {
        this.setValue(byArray);
    }

    protected abstract String convert(byte[] var1);

    protected abstract byte[] convert(String var1);
}

