/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class ASN1Time
extends ASN1Primitive {
    protected Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    public Calendar getTime() {
        return this.calendar;
    }

    public boolean equals(Object object) {
        if (object instanceof ASN1Time) {
            return this.equals((ASN1Time)object);
        }
        return false;
    }

    public boolean equals(ASN1Time aSN1Time) {
        if (this.calendar == null) {
            return aSN1Time.calendar == null;
        }
        if (aSN1Time.calendar == null) {
            return false;
        }
        return this.calendar.getTime().equals(aSN1Time.calendar.getTime());
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeTime(this);
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeTime(this);
    }

    private static int getDigit(byte by) throws ASN1ParsingException {
        if (!Character.isDigit((char)by)) {
            throw new ASN1ParsingException(Resources.getMessage("10"));
        }
        return by - 48;
    }

    protected void convertToCalendar(byte[] byArray, boolean bl) {
        try {
            if (bl && byArray.length < 11 || !bl && byArray.length < 13) {
                throw new ASN1ParsingException(Resources.getMessage("10"));
            }
            int[] nArray = new int[6];
            int n = 0;
            int n2 = n + byArray.length;
            if (!bl) {
                nArray[0] = ASN1Time.getDigit(byArray[n++]) * 1000;
                nArray[0] = nArray[0] + ASN1Time.getDigit(byArray[n++]) * 100;
            }
            nArray[0] = nArray[0] + ASN1Time.getDigit(byArray[n++]) * 10;
            nArray[0] = nArray[0] + ASN1Time.getDigit(byArray[n++]);
            if (bl) {
                nArray[0] = nArray[0] + (nArray[0] >= 50 ? 1900 : 2000);
            }
            nArray[1] = ASN1Time.getDigit(byArray[n++]) * 10;
            nArray[1] = nArray[1] + ASN1Time.getDigit(byArray[n++]);
            nArray[2] = ASN1Time.getDigit(byArray[n++]) * 10;
            nArray[2] = nArray[2] + ASN1Time.getDigit(byArray[n++]);
            nArray[3] = ASN1Time.getDigit(byArray[n++]) * 10;
            nArray[3] = nArray[3] + ASN1Time.getDigit(byArray[n++]);
            nArray[4] = ASN1Time.getDigit(byArray[n++]) * 10;
            nArray[4] = nArray[4] + ASN1Time.getDigit(byArray[n++]);
            boolean bl2 = false;
            if (byArray[n] == 90) {
                if (++n != n2) {
                    bl2 = true;
                }
            } else {
                nArray[5] = ASN1Time.getDigit(byArray[n++]) * 10;
                nArray[5] = nArray[5] + ASN1Time.getDigit(byArray[n++]);
            }
            if (nArray[0] < 1000 || nArray[0] > 9999) {
                bl2 = true;
            }
            block7: while (!bl2 && n < n2) {
                switch (byArray[n++]) {
                    case 90: {
                        continue block7;
                    }
                    case 46: {
                        for (int i = 0; i < 3; ++i) {
                            ASN1Time.getDigit(byArray[n++]);
                        }
                        continue block7;
                    }
                    case 43: 
                    case 45: {
                        n += 4;
                        continue block7;
                    }
                }
                bl2 = true;
            }
            if (bl2 || n != n2) {
                throw new ASN1ParsingException(Resources.getMessage("10"));
            }
            this.calendar.set(1, nArray[0]);
            this.calendar.set(2, nArray[1] - 1);
            this.calendar.set(5, nArray[2]);
            this.calendar.set(11, nArray[3]);
            this.calendar.set(12, nArray[4]);
            this.calendar.set(13, nArray[5]);
            this.calendar.set(14, 0);
        }
        catch (Exception exception) {
            this.calendar = null;
        }
    }
}

