/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.DERInputStream;
import com.certicom.security.asn1.DEROutputStream;

public abstract class ASN1Type {
    private static int maxObjectLength = 65535;
    private static final int NOT_EXPLICIT_TAG = 65535;
    int theExplicitTag = 65535;
    byte theTag;
    boolean initTag = false;

    public final byte tag() {
        if (this.initTag) {
            return this.theTag;
        }
        return this.typeTag();
    }

    public abstract byte typeTag();

    public void setTag(byte by) {
        this.initTag = true;
        this.theTag = by;
        this.theExplicitTag = 65535;
    }

    public void setImplicitTag(byte by) {
        this.setTag(by);
    }

    public void setExplicitTag(int n) {
        this.theExplicitTag = n;
    }

    public boolean explicitlyTagged() {
        return this.theExplicitTag != 65535;
    }

    public abstract void encode(ASN1OutputStream var1) throws ASN1EncodingException;

    public byte[] encode() {
        try {
            DEROutputStream dEROutputStream = new DEROutputStream();
            this.encode(dEROutputStream);
            return dEROutputStream.toByteArray();
        }
        catch (ASN1EncodingException aSN1EncodingException) {
            return null;
        }
    }

    public abstract void decode(ASN1InputStream var1) throws ASN1ParsingException;

    public void decode(byte[] byArray) throws ASN1ParsingException {
        DERInputStream dERInputStream = new DERInputStream(byArray);
        this.decode(dERInputStream);
    }

    public static synchronized void setMaxObjectLength(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(Resources.getMessage("282"));
        }
        maxObjectLength = n;
    }

    public static synchronized int getMaxObjectLength() {
        return maxObjectLength;
    }
}

