/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.DERInputStream;
import java.io.IOException;
import java.io.InputStream;

class DERDefiniteLengthInputStream
extends InputStream {
    private DERInputStream istream;
    private int length;
    static final int MARK_BUF_CAPACITY = 1;
    byte markedByte;
    int readSinceMark;
    boolean marked;
    boolean readMarkedByte;

    DERDefiniteLengthInputStream(DERInputStream dERInputStream, int n) {
        this.istream = dERInputStream;
        this.length = n;
        this.readSinceMark = 0;
        this.marked = false;
        this.readMarkedByte = false;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.marked = true;
        if (this.readSinceMark > 0) {
            this.readMarkedByte = false;
        }
        this.readSinceMark = 0;
    }

    public void reset() throws IOException {
        if (!this.marked || this.readSinceMark > 1) {
            throw new IOException(Resources.getMessage("197"));
        }
        this.readSinceMark = 0;
        this.readMarkedByte = true;
        ++this.length;
    }

    public int available() {
        return this.length;
    }

    public int read() throws IOException {
        byte by = 0;
        if (this.length < 1) {
            throw new IOException(Resources.getMessage("199"));
        }
        try {
            if (this.readMarkedByte) {
                by = this.markedByte;
                this.readMarkedByte = false;
            } else {
                by = this.istream.readOrFail();
            }
            if (this.marked) {
                ++this.readSinceMark;
                this.markedByte = by;
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IOException(aSN1ParsingException.getMessage());
        }
        --this.length;
        return by;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 > this.length) {
            return -1;
        }
        if (byArray == null || n2 == 0) {
            return 0;
        }
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        try {
            if (this.readMarkedByte) {
                this.readMarkedByte = false;
                byArray[n] = this.markedByte;
                if (n2 > 1) {
                    this.istream.readOrFail(byArray, n + 1, n2 - 1);
                }
            } else {
                this.istream.readOrFail(byArray, n, n2);
            }
            n3 = n2;
            if (this.marked) {
                this.markedByte = byArray[n];
                this.readSinceMark = n3;
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IOException(aSN1ParsingException.getMessage());
        }
        this.length -= n3;
        return n3;
    }
}

