/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1Boolean;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1Null;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Set;
import com.certicom.security.asn1.ASN1SetOf;
import com.certicom.security.asn1.ASN1String;
import com.certicom.security.asn1.ASN1Structured;
import com.certicom.security.asn1.ASN1Time;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.asn1.DERDefiniteLengthInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DERInputStream
implements ASN1InputStream {
    InputStream inputStream = null;
    boolean keepReadBytes = false;
    ByteArrayOutputStream keepByteStream = null;

    public DERInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public DERInputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public void decodeBitString(ASN1BitString aSN1BitString) throws ASN1ParsingException {
        byte by;
        Header header = new Header(0, 0, true);
        this.decodeHeader(aSN1BitString, header);
        if (header.primitive) {
            if (header.length < 0) {
                throw new ASN1ParsingException(Resources.getMessage("263"));
            }
            by = this.readOrFail();
            if (by > 7 || by < 0) {
                throw new ASN1ParsingException("Illegal unused bits value");
            }
            --header.length;
        } else {
            throw new ASN1ParsingException(Resources.getMessage("200"));
        }
        byte[] byArray = new byte[header.length];
        this.readOrFail(byArray, 0, header.length);
        aSN1BitString.setBufferTo(byArray);
        aSN1BitString.setUnusedBits(by);
    }

    public void decodeBoolean(ASN1Boolean aSN1Boolean) throws ASN1ParsingException {
        this.decodePrimitive(aSN1Boolean);
    }

    public void decodeInteger(ASN1Integer aSN1Integer) throws ASN1ParsingException {
        this.decodePrimitive(aSN1Integer);
    }

    public void decodeNull(ASN1Null aSN1Null) throws ASN1ParsingException {
        this.decodePrimitive(aSN1Null);
    }

    public void decodeOctetString(ASN1OctetString aSN1OctetString) throws ASN1ParsingException {
        Header header = new Header(0, 0, true);
        this.decodeHeader(aSN1OctetString, header);
        if (header.primitive) {
            if (header.length < 0) {
                throw new ASN1ParsingException(Resources.getMessage("263"));
            }
        } else {
            throw new ASN1ParsingException(Resources.getMessage("201"));
        }
        byte[] byArray = new byte[header.length];
        this.readOrFail(byArray, 0, header.length);
        aSN1OctetString.setBufferTo(byArray);
    }

    public void decodeString(ASN1String aSN1String) throws ASN1ParsingException {
        Header header = new Header(0, 0, true);
        this.decodeHeader(aSN1String, header);
        if (header.primitive) {
            if (header.length < 0) {
                throw new ASN1ParsingException(Resources.getMessage("263"));
            }
        } else {
            throw new ASN1ParsingException(Resources.getMessage("202"));
        }
        byte[] byArray = new byte[header.length];
        this.readOrFail(byArray, 0, header.length);
        aSN1String.setBufferTo(byArray);
    }

    public void decodeOID(ASN1OID aSN1OID) throws ASN1ParsingException {
        this.decodePrimitive(aSN1OID);
    }

    public void decodeTime(ASN1Time aSN1Time) throws ASN1ParsingException {
        this.decodePrimitive(aSN1Time);
    }

    public void decodeSequence(ASN1Sequence aSN1Sequence) throws ASN1ParsingException {
        this.decodeStructured(aSN1Sequence);
    }

    public void decodeSet(ASN1Set aSN1Set) throws ASN1ParsingException {
        this.decodeStructured(aSN1Set);
    }

    public void decodeSetOf(ASN1SetOf aSN1SetOf) throws ASN1ParsingException {
        this.decodeStructured(aSN1SetOf);
    }

    public int peekTag() {
        try {
            if (this.inputStream.available() > 0) {
                this.inputStream.mark(1);
                byte by = this.readOrFail();
                this.inputStream.reset();
                return (byte)(by & 0xFFFFFFDF);
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            WeblogicHandler.debugEaten(aSN1ParsingException);
        }
        return -1;
    }

    public int available() {
        try {
            return this.inputStream.available();
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            return 0;
        }
    }

    public void skip() {
        try {
            if (!this.keepReadBytes) {
                this.inputStream.skip(this.inputStream.available());
            } else {
                try {
                    int n = this.inputStream.available();
                    byte[] byArray = new byte[n];
                    this.readOrFail(byArray, 0, n);
                }
                catch (ASN1ParsingException aSN1ParsingException) {
                    WeblogicHandler.debugEaten(aSN1ParsingException);
                }
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    public boolean eof() {
        try {
            return this.inputStream.available() == 0;
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            return true;
        }
    }

    private void decodeHeader(ASN1Type aSN1Type, Header header) throws ASN1ParsingException {
        this.decodeIdentifier(header);
        this.decodeLength(header);
        if (aSN1Type.explicitlyTagged()) {
            if (header.tag != (byte)aSN1Type.theExplicitTag) {
                throw new ASN1ParsingException(Resources.getMessage("203"));
            }
            this.decodeIdentifier(header);
            this.decodeLength(header);
        }
        if (header.tag != aSN1Type.tag()) {
            throw new ASN1ParsingException(Resources.getMessage("204"));
        }
    }

    private void decodeIdentifier(Header header) throws ASN1ParsingException {
        byte by = this.readOrFail();
        if ((by & 0x1F) != 31) {
            header.tag = (byte)(by & 0xFFFFFFDF);
            header.primitive = (by & 0x20) != 32;
        } else {
            header.tag = (byte)(by & 0xFFFFFFA0);
            header.primitive = (by & 0x20) != 32;
            by = this.readOrFail();
            if ((by & 0xE0) != 0) {
                throw new ASN1ParsingException(Resources.getMessage("205"));
            }
            header.tag = (byte)(header.tag | (byte)(by & 0x1F));
        }
    }

    private void decodeLength(Header header) throws ASN1ParsingException {
        int n = this.readOrFail();
        if ((n & 0x80) != 0) {
            if ((n = (byte)(n & 0x7F)) > 4) {
                throw new ASN1ParsingException(Resources.getMessage("206"));
            }
            header.length = 0;
            if (n > 0) {
                byte[] byArray = new byte[4];
                this.readOrFail(byArray, 0, n);
                for (int i = 0; i < n; ++i) {
                    header.length <<= 8;
                    header.length |= byArray[i] & 0xFF;
                }
            }
            if (header.length == 0) {
                header.length = -1;
            }
        } else {
            header.length = n;
        }
        if (header.length > ASN1Type.getMaxObjectLength()) {
            throw new ASN1ParsingException(Resources.getMessage("274") + " " + ASN1Type.getMaxObjectLength());
        }
    }

    private void decodePrimitive(ASN1Primitive aSN1Primitive) throws ASN1ParsingException {
        Header header = new Header(0, 0, true);
        this.decodeHeader(aSN1Primitive, header);
        if (!header.primitive) {
            throw new ASN1ParsingException(Resources.getMessage("207"));
        }
        if (header.length < 0) {
            throw new ASN1ParsingException(Resources.getMessage("263"));
        }
        byte[] byArray = new byte[header.length];
        this.readOrFail(byArray, 0, header.length);
        aSN1Primitive.setBufferTo(byArray);
    }

    private void decodeStructured(ASN1Structured aSN1Structured) throws ASN1ParsingException {
        Header header = new Header(0, 0, false);
        this.decodeHeader(aSN1Structured, header);
        if (header.tag != aSN1Structured.tag()) {
            throw new ASN1ParsingException(Resources.getMessage("204"));
        }
        if (header.primitive) {
            throw new ASN1ParsingException(Resources.getMessage("208"));
        }
        if (header.length < 0) {
            aSN1Structured.decodeContents(this);
            byte[] byArray = new byte[2];
            this.readOrFail(byArray, 0, 2);
            if (byArray[0] != 0 || byArray[1] != 0) {
                throw new ASN1ParsingException(Resources.getMessage("209"));
            }
        } else {
            DERDefiniteLengthInputStream dERDefiniteLengthInputStream = new DERDefiniteLengthInputStream(this, header.length);
            DERInputStream dERInputStream = new DERInputStream(dERDefiniteLengthInputStream);
            aSN1Structured.decodeContents(dERInputStream);
            if (dERDefiniteLengthInputStream.available() > 0) {
                throw new ASN1ParsingException(Resources.getMessage("210"));
            }
        }
    }

    byte readOrFail() throws ASN1ParsingException {
        byte[] byArray = new byte[1];
        this.readOrFail(byArray, 0, 1);
        return byArray[0];
    }

    void readOrFail(byte[] byArray, int n, int n2) throws ASN1ParsingException {
        int n3 = -1;
        if (n2 == 0) {
            return;
        }
        try {
            n3 = this.inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("Unexpected end of data");
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            throw new ASN1ParsingException(iOException.getMessage());
        }
        if (this.keepReadBytes) {
            this.keepByteStream.write(byArray, n, n3);
        }
        if (n3 != n2) {
            throw new ASN1ParsingException(Resources.getMessage("211"));
        }
    }

    public void enableKeepReadBytes() {
        if (!this.keepReadBytes) {
            this.keepByteStream = new ByteArrayOutputStream();
            this.keepReadBytes = true;
        }
    }

    public boolean isKeepReadBytes() {
        return this.keepReadBytes;
    }

    public byte[] getKeptBytes() {
        if (!this.keepReadBytes) {
            return null;
        }
        return this.keepByteStream.toByteArray();
    }

    public void disableKeepReadBytes() {
        if (this.keepReadBytes) {
            this.keepByteStream = null;
            this.keepReadBytes = false;
        }
    }

    class Header {
        byte tag;
        int length;
        boolean primitive;

        public Header(byte by, int n, boolean bl) {
            this.tag = by;
            this.length = n;
            this.primitive = bl;
        }
    }
}

