/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1Boolean;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1Null;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1Primitive;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Set;
import com.certicom.security.asn1.ASN1SetOf;
import com.certicom.security.asn1.ASN1String;
import com.certicom.security.asn1.ASN1Structured;
import com.certicom.security.asn1.ASN1Time;

class DEROutputSizer
implements ASN1OutputStream {
    private int len = 0;

    DEROutputSizer() {
    }

    public int length() {
        return this.len;
    }

    public void encodeBitString(ASN1BitString aSN1BitString) {
        byte[] byArray = aSN1BitString.toByteArray();
        if (byArray == null) {
            this.encodeHeader(aSN1BitString.tag(), 0, true);
        } else {
            int n = byArray.length;
            this.encodeHeader(aSN1BitString.tag(), n + 1, true);
            this.len += n + 1;
        }
    }

    public void encodeBoolean(ASN1Boolean aSN1Boolean) {
        this.encodePrimitive(aSN1Boolean);
    }

    public void encodeInteger(ASN1Integer aSN1Integer) {
        this.encodePrimitive(aSN1Integer);
    }

    public void encodeNull(ASN1Null aSN1Null) {
        this.encodePrimitive(aSN1Null);
    }

    public void encodeOctetString(ASN1OctetString aSN1OctetString) {
        this.encodePrimitive(aSN1OctetString);
    }

    public void encodeString(ASN1String aSN1String) {
        this.encodePrimitive(aSN1String);
    }

    public void encodeOID(ASN1OID aSN1OID) {
        this.encodePrimitive(aSN1OID);
    }

    public void encodeTime(ASN1Time aSN1Time) {
        this.encodePrimitive(aSN1Time);
    }

    public void encodeSequence(ASN1Sequence aSN1Sequence) {
        this.encodeStructured(aSN1Sequence);
    }

    public void encodeSet(ASN1Set aSN1Set) {
        this.encodeStructured(aSN1Set);
    }

    public void encodeSetOf(ASN1SetOf aSN1SetOf) {
        this.encodeStructured(aSN1SetOf);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.len += n2;
    }

    private void encodeHeader(byte by, int n, boolean bl) {
        this.len += 2;
        if (n >= 128) {
            int n2 = 0;
            for (int i = n; i > 0; i >>= 8) {
                ++n2;
            }
            this.len += n2;
        }
    }

    private void encodePrimitive(ASN1Primitive aSN1Primitive) {
        byte[] byArray = aSN1Primitive.toByteArray();
        if (byArray == null) {
            this.encodeHeader(aSN1Primitive.tag(), 0, true);
        } else {
            int n = byArray.length;
            this.encodeHeader(aSN1Primitive.tag(), n, true);
            this.len += n;
        }
    }

    private void encodeStructured(ASN1Structured aSN1Structured) {
        int n = this.len;
        try {
            aSN1Structured.encodeContents(this);
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
        this.encodeHeader(aSN1Structured.tag(), this.len - n, false);
    }
}

