/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1Boolean;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1Null;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1Primitive;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Set;
import com.certicom.security.asn1.ASN1SetOf;
import com.certicom.security.asn1.ASN1String;
import com.certicom.security.asn1.ASN1Time;
import com.certicom.security.asn1.DERByteArrayOutputStream;
import com.certicom.security.asn1.DEROutputSizer;
import com.certicom.security.asn1.DERSetOfOutputStream;
import com.certicom.security.asn1.DERSetOutputStream;
import java.io.IOException;

public class DEROutputStream
implements ASN1OutputStream {
    private DERByteArrayOutputStream ostream = new DERByteArrayOutputStream();

    public void encodeBitString(ASN1BitString aSN1BitString) throws ASN1EncodingException {
        byte[] byArray = aSN1BitString.toByteArray();
        if (byArray != null) {
            this.encodeHeader(aSN1BitString.tag(), byArray.length + 1, true);
            this.write((byte)aSN1BitString.getUnusedBits());
            this.write(byArray);
        } else {
            this.encodeHeader(aSN1BitString.tag(), 0, true);
        }
    }

    public void encodeBoolean(ASN1Boolean aSN1Boolean) throws ASN1EncodingException {
        this.encodePrimitive(aSN1Boolean);
    }

    public void encodeInteger(ASN1Integer aSN1Integer) throws ASN1EncodingException {
        this.encodePrimitive(aSN1Integer);
    }

    public void encodeNull(ASN1Null aSN1Null) throws ASN1EncodingException {
        this.encodePrimitive(aSN1Null);
    }

    public void encodeOctetString(ASN1OctetString aSN1OctetString) throws ASN1EncodingException {
        this.encodePrimitive(aSN1OctetString);
    }

    public void encodeString(ASN1String aSN1String) throws ASN1EncodingException {
        this.encodePrimitive(aSN1String);
    }

    public void encodeOID(ASN1OID aSN1OID) throws ASN1EncodingException {
        this.encodePrimitive(aSN1OID);
    }

    public void encodeTime(ASN1Time aSN1Time) throws ASN1EncodingException {
        this.encodePrimitive(aSN1Time);
    }

    public void encodeSequence(ASN1Sequence aSN1Sequence) throws ASN1EncodingException {
        DEROutputSizer dEROutputSizer = new DEROutputSizer();
        aSN1Sequence.encodeContents(dEROutputSizer);
        this.encodeHeader(aSN1Sequence.tag(), dEROutputSizer.length(), false);
        aSN1Sequence.encodeContents(this);
    }

    public void encodeSet(ASN1Set aSN1Set) throws ASN1EncodingException {
        DEROutputSizer dEROutputSizer = new DEROutputSizer();
        aSN1Set.encodeContents(dEROutputSizer);
        this.encodeHeader(aSN1Set.tag(), dEROutputSizer.length(), false);
        DERSetOutputStream dERSetOutputStream = new DERSetOutputStream();
        aSN1Set.encodeContents(dERSetOutputStream);
        dERSetOutputStream.writeTo(this.ostream);
    }

    public void encodeSetOf(ASN1SetOf aSN1SetOf) throws ASN1EncodingException {
        DEROutputSizer dEROutputSizer = new DEROutputSizer();
        aSN1SetOf.encodeContents(dEROutputSizer);
        this.encodeHeader(aSN1SetOf.tag(), dEROutputSizer.length(), false);
        DERSetOfOutputStream dERSetOfOutputStream = new DERSetOfOutputStream();
        aSN1SetOf.encodeContents(dERSetOfOutputStream);
        dERSetOfOutputStream.writeTo(this.ostream);
    }

    public void write(byte[] byArray, int n, int n2) throws ASN1EncodingException {
        this.ostream.write(byArray, n, n2);
    }

    private void encodeIdentifier(byte by, boolean bl) throws ASN1EncodingException {
        if (bl) {
            this.write((byte)(by & 0xFFFFFFDF));
        } else {
            this.write((byte)(by | 0x20));
        }
    }

    private void encodeHeader(byte by, int n, boolean bl) throws ASN1EncodingException {
        this.encodeIdentifier(by, bl);
        this.encodeLength(n);
    }

    private void encodeLength(int n) throws ASN1EncodingException {
        if (n < 128) {
            this.write((byte)n);
        } else {
            int n2 = 0;
            n2 = n < 256 ? 1 : (n < 65536 ? 2 : (n < 0x1000000 ? 3 : 4));
            this.write((byte)(0x80 | n2));
            switch (n2) {
                case 4: {
                    this.write((byte)(n >> 24));
                }
                case 3: {
                    this.write((byte)(n >> 16));
                }
                case 2: {
                    this.write((byte)(n >> 8));
                }
                case 1: {
                    this.write((byte)n);
                }
            }
        }
    }

    private void encodePrimitive(ASN1Primitive aSN1Primitive) throws ASN1EncodingException {
        byte[] byArray = aSN1Primitive.toByteArray();
        if (byArray != null) {
            this.encodeHeader(aSN1Primitive.tag(), byArray.length, true);
            this.write(byArray);
        } else {
            this.encodeHeader(aSN1Primitive.tag(), 0, true);
        }
    }

    public byte[] toByteArray() {
        return this.ostream.toByteArray();
    }

    private void write(byte by) {
        this.ostream.write(by);
    }

    private void write(byte[] byArray) throws ASN1EncodingException {
        try {
            this.ostream.write(byArray);
        }
        catch (IOException iOException) {
            throw new ASN1EncodingException(Resources.getMessage("212"));
        }
    }
}

