/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1Boolean;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1Null;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Set;
import com.certicom.security.asn1.ASN1SetOf;
import com.certicom.security.asn1.ASN1String;
import com.certicom.security.asn1.ASN1Time;
import com.certicom.security.asn1.ASN1Type;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

class DERSetOutputStream
implements ASN1OutputStream {
    private int len = 0;
    private Vector components = new Vector();

    public int length() {
        return this.len;
    }

    public void encodeBitString(ASN1BitString aSN1BitString) throws ASN1EncodingException {
        this.encodeComponent(aSN1BitString);
    }

    public void encodeBoolean(ASN1Boolean aSN1Boolean) throws ASN1EncodingException {
        this.encodeComponent(aSN1Boolean);
    }

    public void encodeInteger(ASN1Integer aSN1Integer) throws ASN1EncodingException {
        this.encodeComponent(aSN1Integer);
    }

    public void encodeNull(ASN1Null aSN1Null) throws ASN1EncodingException {
        this.encodeComponent(aSN1Null);
    }

    public void encodeOctetString(ASN1OctetString aSN1OctetString) throws ASN1EncodingException {
        this.encodeComponent(aSN1OctetString);
    }

    public void encodeString(ASN1String aSN1String) throws ASN1EncodingException {
        this.encodeComponent(aSN1String);
    }

    public void encodeOID(ASN1OID aSN1OID) throws ASN1EncodingException {
        this.encodeComponent(aSN1OID);
    }

    public void encodeTime(ASN1Time aSN1Time) throws ASN1EncodingException {
        this.encodeComponent(aSN1Time);
    }

    public void encodeSequence(ASN1Sequence aSN1Sequence) throws ASN1EncodingException {
        this.encodeComponent(aSN1Sequence);
    }

    public void encodeSet(ASN1Set aSN1Set) throws ASN1EncodingException {
        this.encodeComponent(aSN1Set);
    }

    public void encodeSetOf(ASN1SetOf aSN1SetOf) throws ASN1EncodingException {
        this.encodeComponent(aSN1SetOf);
    }

    public void write(byte[] byArray, int n, int n2) throws ASN1EncodingException {
        if (byArray == null || n2 == 0 || n + n2 > byArray.length) {
            throw new ASN1EncodingException(Resources.getMessage("213"));
        }
        this.components.addElement(byArray);
        this.len += n2;
    }

    public byte[] toByteArray() {
        return null;
    }

    private void encodeComponent(ASN1Type aSN1Type) throws ASN1EncodingException {
        byte[] byArray = aSN1Type.encode();
        if (byArray == null) {
            throw new ASN1EncodingException(Resources.getMessage("213"));
        }
        this.components.addElement(byArray);
        this.len += byArray.length;
    }

    public void writeTo(OutputStream outputStream) throws ASN1EncodingException {
        int n;
        int n2 = this.components.size();
        boolean bl = false;
        int n3 = n2;
        while (!bl) {
            bl = true;
            for (n = 1; n < n3; ++n) {
                byte[] byArray;
                byte[] byArray2 = (byte[])this.components.elementAt(n - 1);
                if (this.compare(byArray2, byArray = (byte[])this.components.elementAt(n)) <= 0) continue;
                this.components.setElementAt(byArray, n - 1);
                this.components.setElementAt(byArray2, n);
                bl = false;
            }
            --n3;
        }
        try {
            for (n = 0; n < n2; ++n) {
                outputStream.write((byte[])this.components.elementAt(n));
            }
        }
        catch (IOException iOException) {
            throw new ASN1EncodingException(Resources.getMessage("214"));
        }
    }

    protected int compare(byte[] byArray, byte[] byArray2) {
        if (byArray[0] < byArray2[0]) {
            return -1;
        }
        if (byArray[0] > byArray2[0]) {
            return 1;
        }
        return 0;
    }
}

