/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.DERInputStream;

public class RawInputStream {
    DERInputStream derStream;
    byte[] header;
    int bytesUsed;

    public RawInputStream(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        if (!(aSN1InputStream instanceof DERInputStream)) {
            throw new ASN1ParsingException(Resources.getMessage("215"));
        }
        this.derStream = (DERInputStream)aSN1InputStream;
        this.header = null;
        this.bytesUsed = 0;
    }

    public byte[] readBytes(int n) throws ASN1ParsingException {
        byte[] byArray = new byte[n];
        this.derStream.readOrFail(byArray, 0, n);
        return byArray;
    }

    public byte[] readASN1Object() throws ASN1ParsingException {
        this.header = new byte[16];
        this.bytesUsed = 0;
        this.header[this.bytesUsed++] = this.derStream.readOrFail();
        int n = this.decodeLength();
        if (n < 0) {
            throw new ASN1ParsingException(Resources.getMessage("216"));
        }
        byte[] byArray = new byte[this.bytesUsed + n];
        System.arraycopy(this.header, 0, byArray, 0, this.bytesUsed);
        this.derStream.readOrFail(byArray, this.bytesUsed, n);
        return byArray;
    }

    private int decodeLength() throws ASN1ParsingException {
        int n = 0;
        int n2 = this.derStream.readOrFail();
        this.header[this.bytesUsed++] = n2;
        if ((n2 & 0x80) != 0) {
            if ((n2 = (byte)(n2 & 0x7F)) > 4) {
                throw new ASN1ParsingException(Resources.getMessage("206"));
            }
            byte[] byArray = new byte[n2];
            this.derStream.readOrFail(byArray, 0, n2);
            System.arraycopy(byArray, 0, this.header, this.bytesUsed, n2);
            this.bytesUsed += n2;
            for (int i = 0; i < n2; ++i) {
                n <<= 8;
                n |= byArray[i] & 0xFF;
            }
            if (n == 0) {
                n = -1;
            }
        } else {
            n = n2;
        }
        return n;
    }
}

