/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.cert;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.cert.internal.x509.Base64;
import com.certicom.security.cert.internal.x509.PKCS8;
import com.certicom.security.pkcs.pkcs1.RSAPublicKey;
import com.certicom.security.pkcs.pkcs10.CertificateRequest;
import com.certicom.security.pkcs.pkcs10.CertificateRequestInfo;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.pkix.Name;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.tls.provider.Signature;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;

public class PKCS10 {
    private byte[] encodedRequest;
    PublicKey publicKey;
    String name;

    public PKCS10(PublicKey publicKey, String string) {
        this.publicKey = publicKey;
        this.name = string;
    }

    public byte[] getEncoded() {
        return this.encodedRequest;
    }

    public String exportRequest() {
        String string = new String("-----BEGIN NEW CERTIFICATE REQUEST-----\n");
        String string2 = new String();
        Base64 base64 = new Base64();
        String string3 = Base64.encode(this.encodedRequest);
        for (int i = 0; i < string3.length(); i += 64) {
            string2 = string2.concat(string3.substring(i, i + (string3.length() - i > 64 ? 64 : string3.length() - i)));
            string2 = string2.concat("\n");
        }
        string = string.concat(string2);
        return string.concat("-----END NEW CERTIFICATE REQUEST-----\n");
    }

    public String exportPrivateKey(PrivateKey privateKey, char[] cArray, SecureRandom secureRandom) throws CertificateEncodingException {
        Base64 base64 = new Base64();
        String string = Base64.encode(PKCS8.encrypt(privateKey, new String(cArray), secureRandom));
        String string2 = new String();
        for (int i = 0; i < string.length(); i += 64) {
            string2 = string2.concat(string.substring(i, i + (string.length() - i > 64 ? 64 : string.length() - i)));
            string2 = string2.concat("\n");
        }
        String string3 = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n" + string2 + "-----END ENCRYPTED PRIVATE KEY-----\n";
        return string3;
    }

    public void encodeAndSign(PrivateKey privateKey, SecureRandom secureRandom) throws CertificateEncodingException {
        try {
            byte[] byArray;
            AlgorithmIdentifier algorithmIdentifier;
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            if (this.publicKey.getFormat() == "X.509") {
                subjectPublicKeyInfo = new SubjectPublicKeyInfo();
                subjectPublicKeyInfo.decode(this.publicKey.getEncoded());
            } else if (this.publicKey.getAlgorithm().indexOf("EC") >= 0) {
                subjectPublicKeyInfo = this.getEncodedECCPublicKey();
            } else if (this.publicKey.getAlgorithm().indexOf("RSA") >= 0) {
                subjectPublicKeyInfo = this.getEncodedRSAPublicKey();
            } else {
                throw new CertificateEncodingException(Resources.getMessage("242"));
            }
            CertificateRequestInfo certificateRequestInfo = new CertificateRequestInfo(new Name(this.name), subjectPublicKeyInfo);
            if (this.publicKey.getAlgorithm().indexOf("EC") >= 0) {
                algorithmIdentifier = new AlgorithmIdentifier("1.2.840.10045.4.1", null);
                byArray = this.getEncodedECCSignature(certificateRequestInfo.encode(), privateKey, secureRandom);
            } else if (this.publicKey.getAlgorithm().indexOf("RSA") >= 0) {
                algorithmIdentifier = new AlgorithmIdentifier("1.2.840.113549.1.1.4", null);
                byArray = this.getEncodedRSASignature(certificateRequestInfo.encode(), privateKey, secureRandom);
            } else {
                throw new CertificateEncodingException(Resources.getMessage("242"));
            }
            CertificateRequest certificateRequest = new CertificateRequest(certificateRequestInfo, algorithmIdentifier, byArray);
            this.encodedRequest = certificateRequest.encode();
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new CertificateEncodingException(exception.getMessage());
        }
    }

    private SubjectPublicKeyInfo getEncodedECCPublicKey() throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier("1.2.840.10045.2.1", new ASN1OID("1.3.132.0.1"));
        return new SubjectPublicKeyInfo(algorithmIdentifier, this.publicKey.getEncoded());
    }

    private SubjectPublicKeyInfo getEncodedRSAPublicKey() throws Exception {
        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)this.publicKey;
        RSAPublicKey rSAPublicKey2 = new RSAPublicKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier("1.2.840.113549.1.1.1", null);
        return new SubjectPublicKeyInfo(algorithmIdentifier, rSAPublicKey2.encode());
    }

    private byte[] getEncodedECCSignature(byte[] byArray, PrivateKey privateKey, SecureRandom secureRandom) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Signature signature = Signature.getInstance("ECDSA");
        signature.initSign(privateKey, secureRandom);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        int n = byArray2.length / 2;
        int n2 = (byArray2[0] & 0x80) != 0 ? 1 : 0;
        int n3 = (byArray2[n] & 0x80) != 0 ? 1 : 0;
        byteArrayOutputStream.write(48);
        byteArrayOutputStream.write((byte)(4 + n2 + n3 + byArray2.length));
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(n + n2);
        if (n2 != 0) {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(byArray2, 0, n);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(n + n3);
        if (n3 != 0) {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(byArray2, n, n);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] getEncodedRSASignature(byte[] byArray, PrivateKey privateKey, SecureRandom secureRandom) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(privateKey, secureRandom);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        return byArray2;
    }
}

