/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.cert.internal.x509;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.pkcs.pkcs1.RSAPrivateKey;
import com.certicom.security.pkcs.pkcs8.PrivateKeyInfo;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.sslplus.EncryptedPrivateKey;
import com.certicom.security.sslplus.SEC1PrivateKey;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.RSAPrivateCrtKey;

public final class PKCS8 {
    public static PrivateKey decrypt(byte[] byArray, String string) throws CertificateParsingException {
        PrivateKey privateKey;
        EncryptedPrivateKey encryptedPrivateKey = new EncryptedPrivateKey();
        try {
            encryptedPrivateKey.decode(byArray);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
            privateKeyInfo.decode(encryptedPrivateKey.getPrivateKey(string));
            privateKey = privateKeyInfo.getPrivateKey();
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new CertificateParsingException(aSN1ParsingException.getMessage());
        }
        return privateKey;
    }

    public static byte[] encrypt(PrivateKey privateKey, String string, SecureRandom secureRandom) throws CertificateEncodingException {
        try {
            Object object;
            byte[] byArray;
            if (privateKey.getFormat() == "PKCS#8") {
                byArray = privateKey.getEncoded();
            } else {
                byte[] byArray2;
                AlgorithmIdentifier algorithmIdentifier;
                object = privateKey.getAlgorithm();
                if (((String)object).indexOf("EC") >= 0) {
                    algorithmIdentifier = new AlgorithmIdentifier("1.2.840.10045.2.1", new ASN1OID("1.3.132.0.1"));
                    byArray2 = new SEC1PrivateKey(privateKey.getEncoded()).encode();
                } else if (((String)object).indexOf("RSA") >= 0) {
                    algorithmIdentifier = new AlgorithmIdentifier("1.2.840.113549.1.1.1", null);
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                    RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                    byArray2 = rSAPrivateKey.encode();
                } else {
                    throw new CertificateEncodingException(Resources.getMessage("242"));
                }
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, byArray2);
                byArray = privateKeyInfo.encode();
            }
            EncryptedPrivateKey encryptedPrivateKey = new EncryptedPrivateKey(byArray, string, secureRandom);
            object = encryptedPrivateKey.encode();
            return object;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw certificateEncodingException;
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }
}

