/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.cert.internal.x509;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.asn1.DERInputStream;
import com.certicom.security.asn1.RawInputStream;
import com.certicom.security.cert.internal.pki.CryptoException;
import com.certicom.security.cert.internal.pki.OpenSSL;
import com.certicom.security.cert.internal.x509.Base64;
import com.certicom.security.cert.internal.x509.KeyEncodingException;
import com.certicom.security.cert.internal.x509.PKCS8;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.security.pkcs.pkcs7.ContentInfo;
import com.certicom.security.pkcs.pkcs7.SignedData;
import com.certicom.security.pkcs.pkcs8.PrivateKeyInfo;
import com.certicom.security.pkix.Certificate;
import com.certicom.tls.provider.KeyFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Vector;

public final class SSLPlusSupport {
    private static final String OPENSSL_PROC_TYPE = "Proc-Type: 4,ENCRYPTED";
    private static final String DEK_INFO_TAG = "DEK-Info: ";
    private static final int OPENSSL_SALT_LEN = 8;
    private static final String DEK_INFO_3DES = "DES-EDE3-CBC";
    private static final String KEYTYPE_RSA = "RSA";
    private static final String KEYTYPE_DSA = "DSA";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector getLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        byte[] byArray = null;
        Vector<Serializable> vector = new Vector<Serializable>();
        PrivateKey privateKey = null;
        try {
            while (!bl) {
                KeyFactory keyFactory;
                String string = bufferedReader.readLine();
                if (string == null) {
                    bl = true;
                    continue;
                }
                if (string.startsWith("-----BEGIN CERTIFICATE-----")) {
                    Object object;
                    byArray = SSLPlusSupport.readBinaryBlock(bufferedReader);
                    boolean bl2 = false;
                    keyFactory = null;
                    SignedData signedData = null;
                    ASN1OctetString aSN1OctetString = null;
                    try {
                        object = new ContentInfo();
                        ((ASN1Type)object).decode(byArray);
                        signedData = (SignedData)((ContentInfo)object).getContent();
                        aSN1OctetString = (ASN1OctetString)signedData.getContentInfo().getContent();
                        bl2 = true;
                    }
                    catch (ASN1ParsingException aSN1ParsingException) {
                        WeblogicHandler.debugEaten(aSN1ParsingException);
                    }
                    if (bl2) {
                        try {
                            if (aSN1OctetString == null) {
                                object = signedData.getCertificates();
                                vector.addElement(new X509V3CertImpl((Certificate)((Vector)object).elementAt(0)));
                                vector.addElement(new X509V3CertImpl((Certificate)((Vector)object).elementAt(1)));
                                continue;
                            }
                            object = new DERInputStream(aSN1OctetString.toByteArray());
                            RawInputStream rawInputStream = new RawInputStream((ASN1InputStream)object);
                            vector.addElement(new X509V3CertImpl(rawInputStream.readASN1Object()));
                            vector.addElement(new X509V3CertImpl(rawInputStream.readASN1Object()));
                            continue;
                        }
                        catch (CertificateParsingException certificateParsingException) {
                            WeblogicHandler.debugEaten(certificateParsingException);
                            throw new KeyManagementException(certificateParsingException.getMessage());
                        }
                    }
                    try {
                        vector.addElement(new X509V3CertImpl(byArray));
                        continue;
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        WeblogicHandler.debugEaten(certificateParsingException);
                        throw new KeyManagementException(certificateParsingException.getMessage());
                    }
                }
                if (string.startsWith("-----BEGIN ENCRYPTED PRIVATE KEY-----") || string.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                    try {
                        if (SSLPlusSupport.isOpenSSLPEMKey(bufferedReader)) {
                            privateKey = SSLPlusSupport.getOpenSSLPEMPrivateKey(bufferedReader, cArray, KEYTYPE_RSA);
                            continue;
                        }
                        byArray = SSLPlusSupport.readBinaryBlock(bufferedReader);
                        privateKey = PKCS8.decrypt(byArray, new String(cArray));
                        continue;
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        if (!string.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                            throw new KeyManagementException();
                        }
                        try {
                            keyFactory = KeyFactory.getInstance(KEYTYPE_RSA);
                            privateKey = keyFactory.createPrivateKey(byArray, "rsa_pkcs1");
                            continue;
                        }
                        catch (Exception exception) {
                            throw new KeyManagementException(exception.getMessage());
                        }
                    }
                }
                if (!string.startsWith("-----BEGIN DSA PRIVATE KEY-----")) continue;
                if (SSLPlusSupport.isOpenSSLPEMKey(bufferedReader)) {
                    privateKey = SSLPlusSupport.getOpenSSLPEMPrivateKey(bufferedReader, cArray, KEYTYPE_DSA);
                    continue;
                }
                byArray = SSLPlusSupport.readBinaryBlock(bufferedReader);
                privateKey = PKCS8.decrypt(byArray, new String(cArray));
            }
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new KeyManagementException(exception.getMessage());
        }
        if (vector.size() > 0 && privateKey != null) {
            vector.addElement(privateKey);
            return vector;
        }
        throw new KeyManagementException(Resources.getMessage("153"));
    }

    private static byte[] readByteBlock(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static X509Certificate[] getLocalIdentityCertChain(InputStream inputStream) throws KeyManagementException {
        ArrayList<X509V3CertImpl> arrayList = new ArrayList<X509V3CertImpl>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (!string.startsWith("-----BEGIN CERTIFICATE-----")) continue;
                byte[] byArray = SSLPlusSupport.readBinaryBlock(bufferedReader);
                boolean bl = false;
                Object var6_7 = null;
                SignedData signedData = null;
                ASN1OctetString aSN1OctetString = null;
                try {
                    object = new ContentInfo();
                    ((ASN1Type)object).decode(byArray);
                    signedData = (SignedData)((ContentInfo)object).getContent();
                    aSN1OctetString = (ASN1OctetString)signedData.getContentInfo().getContent();
                    bl = true;
                }
                catch (ASN1ParsingException aSN1ParsingException) {
                    WeblogicHandler.debugEaten(aSN1ParsingException);
                }
                if (bl) {
                    if (aSN1OctetString == null) {
                        object = signedData.getCertificates();
                        arrayList.add(new X509V3CertImpl((Certificate)((Vector)object).elementAt(0)));
                        arrayList.add(new X509V3CertImpl((Certificate)((Vector)object).elementAt(1)));
                        continue;
                    }
                    object = new DERInputStream(aSN1OctetString.toByteArray());
                    RawInputStream rawInputStream = new RawInputStream((ASN1InputStream)object);
                    arrayList.add(new X509V3CertImpl(rawInputStream.readASN1Object()));
                    arrayList.add(new X509V3CertImpl(rawInputStream.readASN1Object()));
                    continue;
                }
                arrayList.add(new X509V3CertImpl(byArray));
            }
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
            throw new KeyManagementException(exception.getMessage());
        }
        if (arrayList.size() == 0) {
            throw new KeyManagementException(Resources.getMessage("153"));
        }
        return arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    public static PrivateKey getLocalIdentityPrivateKey(InputStream inputStream, char[] cArray) throws KeyManagementException {
        PrivateKey privateKey;
        block19: {
            privateKey = null;
            try {
                KeyFactory keyFactory;
                String string;
                String string2 = cArray == null ? null : new String(cArray);
                byte[] byArray = SSLPlusSupport.readByteBlock(inputStream);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
                while ((string = bufferedReader.readLine()) != null) {
                    byte[] byArray2;
                    if (string.startsWith("-----BEGIN ENCRYPTED PRIVATE KEY-----") || string.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                        if (SSLPlusSupport.isOpenSSLPEMKey(bufferedReader)) {
                            privateKey = SSLPlusSupport.getOpenSSLPEMPrivateKey(bufferedReader, cArray, KEYTYPE_RSA);
                            continue;
                        }
                        byArray2 = SSLPlusSupport.readBinaryBlock(bufferedReader);
                        try {
                            privateKey = PKCS8.decrypt(byArray2, string2);
                            continue;
                        }
                        catch (CertificateParsingException certificateParsingException) {
                            if (string.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                                try {
                                    keyFactory = KeyFactory.getInstance(KEYTYPE_RSA);
                                    privateKey = keyFactory.createPrivateKey(byArray2, "rsa_pkcs1");
                                    continue;
                                }
                                catch (Exception exception) {
                                    throw certificateParsingException;
                                }
                            }
                            throw certificateParsingException;
                        }
                    }
                    if (!string.startsWith("-----BEGIN DSA PRIVATE KEY-----")) continue;
                    if (SSLPlusSupport.isOpenSSLPEMKey(bufferedReader)) {
                        privateKey = SSLPlusSupport.getOpenSSLPEMPrivateKey(bufferedReader, cArray, KEYTYPE_DSA);
                        continue;
                    }
                    byArray2 = SSLPlusSupport.readBinaryBlock(bufferedReader);
                    privateKey = PKCS8.decrypt(byArray2, string2);
                }
                if (privateKey != null) break block19;
                try {
                    privateKey = PKCS8.decrypt(byArray, string2);
                }
                catch (CertificateParsingException certificateParsingException) {
                    try {
                        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
                        privateKeyInfo.decode(byArray);
                        privateKey = privateKeyInfo.getPrivateKey();
                    }
                    catch (Exception exception) {
                        if (cArray == null) {
                            try {
                                keyFactory = KeyFactory.getInstance(KEYTYPE_RSA);
                                privateKey = keyFactory.createPrivateKey(byArray, "rsa_pkcs1");
                                break block19;
                            }
                            catch (Exception exception2) {
                                throw certificateParsingException;
                            }
                        }
                        throw certificateParsingException;
                    }
                }
            }
            catch (Exception exception) {
                WeblogicHandler.debugEaten(exception);
                throw new KeyManagementException(exception.getMessage());
            }
        }
        if (privateKey == null) {
            throw new KeyManagementException(Resources.getMessage("153"));
        }
        return privateKey;
    }

    private static boolean isOpenSSLPEMKey(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(128);
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        if (string.equals(OPENSSL_PROC_TYPE)) {
            return true;
        }
        bufferedReader.reset();
        return false;
    }

    private static PrivateKey getOpenSSLPEMPrivateKey(BufferedReader bufferedReader, char[] cArray, String string) throws IOException, KeyEncodingException, NoSuchAlgorithmException, IllegalArgumentException {
        byte[] byArray = SSLPlusSupport.decryptPEMData(bufferedReader, cArray);
        if (string.equals(KEYTYPE_RSA)) {
            KeyFactory keyFactory = KeyFactory.getInstance(KEYTYPE_RSA);
            return keyFactory.createPrivateKey(byArray, "rsa_pkcs1");
        }
        if (string.equals(KEYTYPE_DSA)) {
            KeyFactory keyFactory = KeyFactory.getInstance(KEYTYPE_DSA);
            return keyFactory.createPrivateKey(byArray, "dsa_openssl_asn1");
        }
        throw new IllegalArgumentException(Resources.getMessage("151") + string);
    }

    private static byte[] decryptPEMData(BufferedReader bufferedReader, char[] cArray) throws IOException, KeyEncodingException {
        byte[] byArray;
        String string;
        OpenSSL openSSL = new OpenSSL();
        do {
            if ((string = bufferedReader.readLine()) == null) {
                throw new IOException(Resources.getMessage("154"));
            }
            if (!string.startsWith("-----END")) continue;
            throw new KeyEncodingException(Resources.getMessage("155") + DEK_INFO_TAG);
        } while (!string.startsWith(DEK_INFO_TAG));
        String string2 = SSLPlusSupport.getDEKInfoCipher(string);
        byte[] byArray2 = SSLPlusSupport.getDEKInfoSalt(string);
        byte[] byArray3 = SSLPlusSupport.readBinaryBlock(bufferedReader);
        byte[] byArray4 = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray4[i] = (byte)(cArray[i] & 0xFF);
        }
        if (!string2.equals(DEK_INFO_3DES)) {
            throw new KeyEncodingException(Resources.getMessage("156") + string2 + Resources.getMessage("66"));
        }
        byte[] byArray5 = new byte[24];
        try {
            openSSL.kdf(byArray4, byArray2, 0, byArray5);
            byArray = openSSL.decrypt(byArray5, byArray2, string2, byArray3);
        }
        catch (CryptoException cryptoException) {
            WeblogicHandler.debugEaten(cryptoException);
            throw new KeyEncodingException(Resources.getMessage("157") + cryptoException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WeblogicHandler.debugEaten(illegalArgumentException);
            throw new KeyEncodingException(Resources.getMessage("157") + illegalArgumentException.getMessage());
        }
        return byArray;
    }

    private static String getDEKInfoCipher(String string) throws KeyEncodingException {
        String string2 = string.substring(DEK_INFO_TAG.length());
        if (string2.indexOf(44) > 0) {
            return string2.substring(0, string2.indexOf(44));
        }
        throw new KeyEncodingException(Resources.getMessage("158"));
    }

    private static byte[] getDEKInfoSalt(String string) throws KeyEncodingException {
        int n;
        if (string.indexOf(44) < 0) {
            throw new KeyEncodingException(Resources.getMessage("159"));
        }
        String string2 = string.substring(string.indexOf(44) + 1);
        if (string2.length() != 16) {
            throw new KeyEncodingException(Resources.getMessage("160"));
        }
        byte[] byArray = new byte[8];
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        for (n = 0; n < string2.length(); ++n) {
            byte by;
            if (string2.charAt(n) >= '0' && string2.charAt(n) <= '9') {
                by = (byte)(string2.charAt(n) - 48);
            } else if (string2.charAt(n) >= 'A' && string2.charAt(n) <= 'F') {
                by = (byte)(string2.charAt(n) - 65 + 10);
            } else if (string2.charAt(n) >= 'a' && string2.charAt(n) <= 'f') {
                by = (byte)(string2.charAt(n) - 97 + 10);
            } else {
                throw new KeyEncodingException(Resources.getMessage("161"));
            }
            int n2 = n / 2;
            byArray[n2] = (byte)(byArray[n2] | by << (n % 2 == 0 ? 4 : 0));
        }
        return byArray;
    }

    public static X509Certificate[] getTrustedCertificates(InputStream inputStream) throws KeyManagementException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        byte[] byArray = null;
        Object var6_4 = null;
        Vector<X509V3CertImpl> vector = new Vector<X509V3CertImpl>();
        try {
            while (!bl) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    bl = true;
                    continue;
                }
                if (!string.startsWith("-----BEGIN CERTIFICATE-----")) continue;
                byArray = SSLPlusSupport.readBinaryBlock(bufferedReader);
                X509V3CertImpl x509V3CertImpl = new X509V3CertImpl(byArray);
                vector.addElement(x509V3CertImpl);
            }
        }
        catch (IOException iOException) {
            throw new KeyManagementException(iOException.getMessage());
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new KeyManagementException(certificateParsingException.getMessage());
        }
        Object[] objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static byte[] readBinaryBlock(BufferedReader bufferedReader) throws IOException {
        String string = null;
        boolean bl = false;
        while (!bl) {
            String string2 = bufferedReader.readLine();
            if (string2.startsWith("-----END")) {
                bl = true;
                continue;
            }
            if (string == null) {
                string = new String(string2);
                continue;
            }
            string = string.concat(string2);
        }
        Base64 base64 = new Base64();
        return Base64.decode(string);
    }

    private static boolean compareArrays(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeLengthDER(int n) {
        int n2 = 0;
        if (n < 128) {
            n2 = 0;
        } else {
            int n3 = 0;
            for (long i = (long)n; i > 0L; i >>>= 8) {
                ++n3;
            }
            n2 = n3;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = n2 > 0 ? 128 + n2 : n;
        byteArrayOutputStream.write((byte)n4);
        int n5 = 0;
        int n6 = (n2 - 1) * 8;
        while (n5 < n2) {
            byteArrayOutputStream.write((byte)(n >> n6));
            ++n5;
            n6 -= 8;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

