/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.cert.internal.x509;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.security.pkix.ExtendedKeyUsage;
import com.certicom.security.pkix.Extensions;
import com.certicom.tls.provider.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Vector;

public final class ServerGatedCryptoCert {
    public static final int SGCNoCertificate = 0;
    public static final int SGCMSCertificate = 1;
    public static final int SGCStepUpCertificate = 2;
    private X509Certificate[] chain;
    private static final byte[] VSClass3PubKeyHash = new byte[]{0, -40, 90, 76, 37, -63, 34, -27, -117, 49, -17, 109, -70, -13, -52, 95, 41, -15, 13, 97};
    private static final byte[] MSSGCRootKeyHash = new byte[]{122, -96, 78, -81, -4, 123, -11, -7, -63, -70, -10, 127, 102, 121, 52, -78, -92, 43, -70, -111};

    public ServerGatedCryptoCert(X509Certificate[] x509CertificateArray) {
        this.chain = x509CertificateArray;
    }

    public int getSGCCertificateType() {
        Object object;
        int n = 0;
        int n2 = this.chain.length;
        Extensions extensions = ((X509V3CertImpl)this.chain[0]).getExtensions();
        if (extensions == null) {
            return 0;
        }
        ExtendedKeyUsage extendedKeyUsage = null;
        try {
            extendedKeyUsage = extensions.getExtendedKeyUsage();
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            // empty catch block
        }
        if (extendedKeyUsage == null) {
            return 0;
        }
        Vector vector = extendedKeyUsage.keyPurposes();
        for (int i = 0; i < vector.size(); ++i) {
            object = (String)vector.elementAt(i);
            if (((String)object).equals("1.3.6.1.4.1.311.10.3.3")) {
                n = 1;
                break;
            }
            if (!((String)object).equals("2.16.840.1.113730.4.1")) continue;
            n = 2;
        }
        if (n == 0) {
            return 0;
        }
        try {
            byte[] byArray = ((X509V3CertImpl)this.chain[n2 - 1]).getCertificate().getPublicKeyInfo().getKey();
            object = MessageDigest.getInstance("SHA");
            ((MessageDigest)object).update(byArray);
            byte[] byArray2 = ((MessageDigest)object).digest();
            for (int i = 0; i < 20; ++i) {
                if (byArray2[i] == VSClass3PubKeyHash[i] || byArray2[i] == MSSGCRootKeyHash[i]) continue;
                return 0;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        return n;
    }
}

