/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.cert.internal.x509;

import com.certicom.locale.Resources;
import com.certicom.security.cert.internal.x509.Base64;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.util.Collection;

public class X509Factory
extends CertificateFactorySpi {
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            InputStream inputStream2 = null;
            boolean bl = false;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 10);
            String string = new String("-----BEGIN CERTIFICATE-----");
            byte[] byArray = new byte[string.length()];
            byte[] byArray2 = string.getBytes();
            bufferedInputStream.mark(30);
            bufferedInputStream.read(byArray, 0, 27);
            if (byArray.length == byArray2.length) {
                bl = true;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                String string2 = "";
                boolean bl2 = false;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                do {
                    int n = -1;
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) {
                        throw new CertificateParsingException("Incomplete cert");
                    }
                    n = string3.indexOf("-----END");
                    if (n >= 0) {
                        string3 = string3.substring(0, n);
                        bl2 = true;
                    }
                    string2 = string2 + string3;
                } while (!bl2);
                byte[] byArray3 = Base64.decode(string2);
                inputStream2 = new ByteArrayInputStream(byArray3);
            } else {
                bufferedInputStream.reset();
                inputStream2 = bufferedInputStream;
            }
            return new X509V3CertImpl(inputStream2);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new CertificateException(certificateParsingException.toString());
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        throw new CertificateException(Resources.getMessage("260"));
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        throw new CRLException(Resources.getMessage("261"));
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        throw new CRLException(Resources.getMessage("262"));
    }
}

