/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.cert.internal.x509;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.asn1.DERInputStream;
import com.certicom.security.cert.internal.x509.PrincipalImpl;
import com.certicom.security.cert.internal.x509.SSLPlusSupport;
import com.certicom.security.pkix.BasicConstraints;
import com.certicom.security.pkix.Certificate;
import com.certicom.security.pkix.ExtendedKeyUsage;
import com.certicom.security.pkix.Extension;
import com.certicom.security.pkix.Extensions;
import com.certicom.security.pkix.KeyUsage;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.Signature;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public final class X509V3CertImpl
extends X509Certificate {
    public static final int v1 = 0;
    public static final int v2 = 1;
    public static final int v3 = 2;
    private Certificate cert = new Certificate();
    private PublicKey cachePublicKey = null;
    private boolean isCachedPublicKey = false;
    private boolean isKeyCompressed = false;
    private transient Principal subjectDN;
    private transient Principal issuerDN;

    public X509V3CertImpl(InputStream inputStream) throws CertificateParsingException {
        try {
            DERInputStream dERInputStream = new DERInputStream(inputStream);
            this.cert.decode(dERInputStream);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new CertificateParsingException(aSN1ParsingException.getMessage());
        }
    }

    public X509V3CertImpl(byte[] byArray) throws CertificateParsingException {
        try {
            this.cert.decode(byArray);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new CertificateParsingException(aSN1ParsingException.getMessage());
        }
    }

    X509V3CertImpl(Certificate certificate) {
        this.cert = certificate;
    }

    private X509V3CertImpl() {
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        Date date2 = this.cert.getValidity().getStart().getTime();
        Date date3 = this.cert.getValidity().getExpiration().getTime();
        if (date.before(date2)) {
            throw new CertificateNotYetValidException(Resources.getMessage("30") + date2.toString());
        }
        if (date.after(date3)) {
            throw new CertificateExpiredException(Resources.getMessage("29") + date3.toString());
        }
    }

    public Principal getIssuerDN() {
        if (this.issuerDN == null) {
            this.issuerDN = new PrincipalImpl(this.cert.getIssuer());
        }
        return this.issuerDN;
    }

    public Date getNotAfter() {
        return this.cert.getValidity().getExpiration().getTime();
    }

    public Date getNotBefore() {
        return this.cert.getValidity().getStart().getTime();
    }

    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public String getSigAlgName() {
        return this.cert.getSignatureAlgorithm();
    }

    public String getSigAlgOID() {
        return this.cert.getSignatureAlgOID();
    }

    public byte[] getSigAlgParams() {
        ASN1Type aSN1Type = this.cert.getSignatureAlgorithmId().getParameters();
        if (aSN1Type == null) {
            return null;
        }
        return aSN1Type.encode();
    }

    public byte[] getSignature() {
        return this.cert.getSignatureBytes();
    }

    public Principal getSubjectDN() {
        if (this.subjectDN == null) {
            this.subjectDN = new PrincipalImpl(this.cert.getSubject());
        }
        return this.subjectDN;
    }

    public byte[] getTBSCertificate() {
        return this.cert.getSignedData();
    }

    public int getVersion() {
        return this.cert.getVersion();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.encode();
    }

    public void verify(PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, this.getSigAlgName());
    }

    public void verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signature = null;
        boolean bl = false;
        byte[] byArray = null;
        if (string == null) {
            string = this.getSigAlgName();
        }
        if (string == null) {
            throw new NoSuchProviderException(Resources.getMessage("14"));
        }
        byArray = this.getSignature();
        if (string.equals("ECDSA")) {
            signature = Signature.getInstance(string);
        } else if (string.equals("SHA/DSA") || string.equals("SHA-1/DSA") || string.indexOf("DSA") >= 0) {
            signature = Signature.getInstance("SHA1withDSA");
        } else if (string.equals("MD5withRSA") || string.equals("SHA1withRSA") || string.equals("SHAwithRSA") || string.equals("MD2withRSA")) {
            signature = Signature.getInstance(string);
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (signature == null || byArray == null) {
            throw new NoSuchProviderException(Resources.getMessage("24") + string);
        }
        bl = signature.verify(byArray);
        if (!bl) {
            throw new SignatureException(Resources.getMessage("60"));
        }
    }

    public String toString() {
        return this.cert.toString();
    }

    public boolean isKeyCompressed() {
        if (!this.isCachedPublicKey) {
            this.getPublicKey();
        }
        return this.isKeyCompressed;
    }

    public PublicKey getPublicKey() {
        if (!this.isCachedPublicKey) {
            try {
                Object object;
                SubjectPublicKeyInfo subjectPublicKeyInfo = this.cert.getPublicKeyInfo();
                byte[] byArray = subjectPublicKeyInfo.encode();
                String string = subjectPublicKeyInfo.getAlgId().getAlgorithm();
                if (string.startsWith("EC")) {
                    object = subjectPublicKeyInfo.getKey();
                    this.isKeyCompressed = object[0] != 4;
                }
                object = KeyFactory.getInstance(string);
                this.cachePublicKey = object.createPublicKey(byArray, "X509");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WeblogicHandler.debugEaten(illegalArgumentException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
            }
            this.isCachedPublicKey = true;
        }
        return this.cachePublicKey;
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    public Extensions getExtensions() {
        return this.cert.getExtensions();
    }

    public int getBasicConstraints() {
        try {
            BasicConstraints basicConstraints;
            Extensions extensions = this.getExtensions();
            if (extensions != null && (basicConstraints = extensions.getBasicConstraints()) != null) {
                return basicConstraints.getPathLen();
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            WeblogicHandler.debugEaten(aSN1ParsingException);
        }
        return -1;
    }

    public boolean[] getKeyUsage() {
        Object object;
        int n = 0;
        try {
            KeyUsage keyUsage;
            object = this.getExtensions();
            if (object != null && (keyUsage = ((Extensions)object).getKeyUsage()) != null) {
                n = keyUsage.getBits();
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            WeblogicHandler.debugEaten(aSN1ParsingException);
        }
        object = new boolean[9];
        int n2 = 0x800000;
        for (int i = 8; i >= 0; --i) {
            object[i] = (n & n2) != 0;
            n2 <<= 1;
        }
        return object;
    }

    public Set getCriticalExtensionOIDs() {
        Extensions extensions = this.getExtensions();
        if (extensions == null) {
            return null;
        }
        Vector vector = extensions.getCriticalExtensionOIDs();
        if (vector.size() == 0) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            if (WeblogicHandler.noStringExtensions()) {
                hashSet.add((ASN1OID)vector.elementAt(i));
                continue;
            }
            hashSet.add((String)vector.elementAt(i));
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        Extensions extensions = this.getExtensions();
        if (extensions == null) {
            return null;
        }
        Vector vector = extensions.getNonCriticalExtensionOIDs();
        if (vector.size() == 0) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            if (WeblogicHandler.noStringExtensions()) {
                hashSet.add((ASN1OID)vector.elementAt(i));
                continue;
            }
            hashSet.add((String)vector.elementAt(i));
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        Extension extension;
        Extensions extensions = this.getExtensions();
        if (extensions != null && (extension = extensions.getExtension(string)) != null) {
            byte[] byArray = extension.getValue();
            byte[] byArray2 = SSLPlusSupport.encodeLengthDER(byArray.length);
            byte[] byArray3 = new byte[byArray.length + byArray2.length + 1];
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length + 1, byArray.length);
            return byArray3;
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public boolean[] getSubjectUniqueID() {
        throw new RuntimeException(Resources.getMessage("258"));
    }

    private List convert(Vector vector) {
        if (vector == null) {
            return null;
        }
        if (vector instanceof List) {
            return vector;
        }
        ArrayList arrayList = new ArrayList(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        Extensions extensions = this.getExtensions();
        if (extensions == null) {
            return null;
        }
        try {
            ExtendedKeyUsage extendedKeyUsage = extensions.getExtendedKeyUsage();
            if (extendedKeyUsage == null) {
                return null;
            }
            return this.convert(extendedKeyUsage.keyPurposes());
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new CertificateParsingException("Failed to obtain extended key usage: " + aSN1ParsingException.getMessage());
        }
    }

    public boolean[] getIssuerUniqueID() {
        throw new RuntimeException(Resources.getMessage("259"));
    }
}

