/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.openssl;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import java.security.spec.DSAPrivateKeySpec;

public class PEMDSAPrivateKey
extends ASN1Sequence {
    ASN1Integer version = new ASN1Integer();
    ASN1Integer p = new ASN1Integer();
    ASN1Integer q = new ASN1Integer();
    ASN1Integer g = new ASN1Integer();
    ASN1Integer x = new ASN1Integer();
    ASN1Integer y = new ASN1Integer();

    public DSAPrivateKeySpec getKeySpec() {
        return new DSAPrivateKeySpec(this.x.toBigInteger(), this.p.toBigInteger(), this.q.toBigInteger(), this.g.toBigInteger());
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.version.decode(aSN1InputStream);
        this.p.decode(aSN1InputStream);
        this.q.decode(aSN1InputStream);
        this.g.decode(aSN1InputStream);
        this.y.decode(aSN1InputStream);
        this.x.decode(aSN1InputStream);
        if (!this.version.toBigInteger().equals(ASN1Integer.ZERO)) {
            throw new ASN1ParsingException(Resources.getMessage("217"));
        }
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.version.encode(aSN1OutputStream);
        this.p.encode(aSN1OutputStream);
        this.q.encode(aSN1OutputStream);
        this.g.encode(aSN1OutputStream);
        this.y.encode(aSN1OutputStream);
        this.x.encode(aSN1OutputStream);
    }
}

