/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public class DSSParams
extends ASN1Sequence {
    ASN1Integer p;
    ASN1Integer q;
    ASN1Integer g;

    public DSSParams() {
        this.p = new ASN1Integer();
        this.q = new ASN1Integer();
        this.g = new ASN1Integer();
    }

    public DSSParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new ASN1Integer(bigInteger);
        this.q = new ASN1Integer(bigInteger2);
        this.g = new ASN1Integer(bigInteger3);
    }

    public DSSParams(DSAParams dSAParams) {
        this.p = new ASN1Integer(dSAParams.getP());
        this.q = new ASN1Integer(dSAParams.getQ());
        this.g = new ASN1Integer(dSAParams.getG());
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.p.decode(aSN1InputStream);
        this.q.decode(aSN1InputStream);
        this.g.decode(aSN1InputStream);
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.p.encode(aSN1OutputStream);
        this.q.encode(aSN1OutputStream);
        this.g.encode(aSN1OutputStream);
    }

    public BigInteger getP() {
        return this.p.toBigInteger();
    }

    public BigInteger getQ() {
        return this.q.toBigInteger();
    }

    public BigInteger getG() {
        return this.g.toBigInteger();
    }

    public DSAParams getParams() {
        return new DSAParameterSpec(this.getP(), this.getQ(), this.getG());
    }
}

