/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs1;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import java.math.BigInteger;
import java.security.spec.RSAPrivateCrtKeySpec;

public class RSAPrivateKey
extends ASN1Sequence {
    ASN1Integer version = new ASN1Integer(ASN1Integer.ZERO);
    ASN1Integer n;
    ASN1Integer e;
    ASN1Integer d;
    ASN1Integer p;
    ASN1Integer q;
    ASN1Integer dp;
    ASN1Integer dq;
    ASN1Integer qinv;

    public RSAPrivateKey() {
        this.n = new ASN1Integer();
        this.e = new ASN1Integer();
        this.d = new ASN1Integer();
        this.p = new ASN1Integer();
        this.q = new ASN1Integer();
        this.dp = new ASN1Integer();
        this.dq = new ASN1Integer();
        this.qinv = new ASN1Integer();
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.n = new ASN1Integer(bigInteger);
        this.e = new ASN1Integer(bigInteger2);
        this.d = new ASN1Integer(bigInteger3);
        this.p = new ASN1Integer(bigInteger4);
        this.q = new ASN1Integer(bigInteger5);
        this.dp = new ASN1Integer(bigInteger6);
        this.dq = new ASN1Integer(bigInteger7);
        this.qinv = new ASN1Integer(bigInteger8);
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.version.decode(aSN1InputStream);
        this.n.decode(aSN1InputStream);
        this.e.decode(aSN1InputStream);
        this.d.decode(aSN1InputStream);
        this.p.decode(aSN1InputStream);
        this.q.decode(aSN1InputStream);
        this.dp.decode(aSN1InputStream);
        this.dq.decode(aSN1InputStream);
        this.qinv.decode(aSN1InputStream);
        if (!this.version.toBigInteger().equals(ASN1Integer.ZERO)) {
            throw new ASN1ParsingException(Resources.getMessage("218"));
        }
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.version.encode(aSN1OutputStream);
        this.n.encode(aSN1OutputStream);
        this.e.encode(aSN1OutputStream);
        this.d.encode(aSN1OutputStream);
        this.p.encode(aSN1OutputStream);
        this.q.encode(aSN1OutputStream);
        this.dp.encode(aSN1OutputStream);
        this.dq.encode(aSN1OutputStream);
        this.qinv.encode(aSN1OutputStream);
    }

    public BigInteger getModulus() {
        return this.n.toBigInteger();
    }

    public BigInteger getPublicExponent() {
        return this.e.toBigInteger();
    }

    public BigInteger getPrivateExponent() {
        return this.d.toBigInteger();
    }

    public BigInteger getPrimeP() {
        return this.p.toBigInteger();
    }

    public BigInteger getPrimeQ() {
        return this.q.toBigInteger();
    }

    public BigInteger getPrimeExponentP() {
        return this.dp.toBigInteger();
    }

    public BigInteger getPrimeExponentQ() {
        return this.dq.toBigInteger();
    }

    public BigInteger getCrtCoefficient() {
        return this.qinv.toBigInteger();
    }

    public RSAPrivateCrtKeySpec getKeySpec() {
        return new RSAPrivateCrtKeySpec(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient());
    }
}

