/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs10;

import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.pkcs.pkcs10.CertificateRequestInfo;
import com.certicom.security.pkix.AlgorithmIdentifier;

public class CertificateRequest
extends ASN1Sequence {
    private CertificateRequestInfo info;
    private AlgorithmIdentifier algId;
    private ASN1BitString signature;

    public CertificateRequest() {
        this.info = new CertificateRequestInfo();
        this.algId = new AlgorithmIdentifier();
        this.signature = new ASN1BitString();
    }

    public CertificateRequest(CertificateRequestInfo certificateRequestInfo, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.info = certificateRequestInfo;
        this.algId = algorithmIdentifier;
        this.signature = new ASN1BitString(byArray);
    }

    public CertificateRequestInfo getCertificateRequestInfo() {
        return this.info;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algId;
    }

    public byte[] getSignature() {
        return this.signature.toByteArray();
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.info.decode(aSN1InputStream);
        this.algId.decode(aSN1InputStream);
        this.signature.decode(aSN1InputStream);
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.info.encode(aSN1OutputStream);
        this.algId.encode(aSN1OutputStream);
        this.signature.encode(aSN1OutputStream);
    }
}

