/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs10;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.pkix.Name;
import com.certicom.security.pkix.SubjectPublicKeyInfo;

public class CertificateRequestInfo
extends ASN1Sequence {
    private ASN1Integer version = new ASN1Integer(ASN1Integer.ZERO);
    private Name subject;
    private SubjectPublicKeyInfo keyInfo;

    public CertificateRequestInfo() {
        this.subject = new Name();
        this.keyInfo = new SubjectPublicKeyInfo();
    }

    public CertificateRequestInfo(Name name, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subject = name;
        this.keyInfo = subjectPublicKeyInfo;
    }

    public CertificateRequestInfo(String string, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws ASN1ParsingException {
        this.subject = new Name(string);
        this.keyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
    }

    public Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getPublicKeyInfo() {
        return this.keyInfo;
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.version.decode(aSN1InputStream);
        this.subject.decode(aSN1InputStream);
        this.keyInfo.decode(aSN1InputStream);
        if (!this.version.toBigInteger().equals(ASN1Integer.ZERO)) {
            throw new ASN1ParsingException(Resources.getMessage("219"));
        }
        if (!aSN1InputStream.eof()) {
            throw new ASN1ParsingException(Resources.getMessage("220"));
        }
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.version.encode(aSN1OutputStream);
        this.subject.encode(aSN1OutputStream);
        this.keyInfo.encode(aSN1OutputStream);
    }
}

