/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs5;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;

public final class PBEParameter
extends ASN1Sequence {
    private ASN1OctetString salt;
    private ASN1Integer iterationCount;

    public PBEParameter() {
        this.salt = new ASN1OctetString(8);
        this.iterationCount = new ASN1Integer();
    }

    public PBEParameter(byte[] byArray, int n) {
        this.salt = new ASN1OctetString(byArray);
        this.iterationCount = new ASN1Integer(n);
    }

    public int getIterationCount() {
        return this.iterationCount.toBigInteger().intValue();
    }

    public byte[] getSalt() {
        return this.salt.toByteArray();
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.salt.decode(aSN1InputStream);
        this.iterationCount.decode(aSN1InputStream);
        if (this.salt.actualLength() != 8) {
            throw new ASN1ParsingException(Resources.getMessage("221"));
        }
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        if (this.salt.actualLength() != 8) {
            throw new ASN1EncodingException(Resources.getMessage("221"));
        }
        this.salt.encode(aSN1OutputStream);
        this.iterationCount.encode(aSN1OutputStream);
    }
}

