/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs5;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.pkcs.pkcs5.PBEParameter;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.spec.GenericKey;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class PBES1 {
    private byte[] plainMessage = null;
    private byte[] encryptedMessage = null;
    private PBEParameter pbeParams = null;
    private String algorithm = null;

    public PBES1(String string, byte[] byArray, String string2, Random random, int n) {
        this.algorithm = string;
        this.plainMessage = byArray;
        byte[] byArray2 = new byte[8];
        random.nextBytes(byArray2);
        this.pbeParams = new PBEParameter(byArray2, n);
        byte[] byArray3 = PBES1.doIterations(string, string2, byArray2, n);
        try {
            this.encryptedMessage = PBES1.doEncrypt(string, byArray, byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
    }

    public PBES1(String string, byte[] byArray, String string2, PBEParameter pBEParameter) {
        this.algorithm = string;
        this.encryptedMessage = byArray;
        this.pbeParams = pBEParameter;
        byte[] byArray2 = pBEParameter.getSalt();
        int n = pBEParameter.getIterationCount();
        byte[] byArray3 = PBES1.doIterations(string, string2, byArray2, n);
        try {
            this.plainMessage = this.doDecrypt(string, byArray, byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
    }

    public byte[] getPlainMessage() {
        return this.plainMessage;
    }

    public byte[] getEncryptedMessage() {
        return this.encryptedMessage;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public PBEParameter getParameters() {
        return this.pbeParams;
    }

    private static byte[] doIterations(String string, String string2, byte[] byArray, int n) {
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = null;
        for (int i = 0; i < n; ++i) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i == 0) {
                messageDigest.update(byArray2);
                messageDigest.update(byArray);
            } else {
                messageDigest.update(byArray3);
            }
            byArray3 = messageDigest.digest();
        }
        return byArray3;
    }

    private byte[] doDecrypt(String string, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        if (byArray.length < 8) {
            throw new NullPointerException(Resources.getMessage("222"));
        }
        if (byArray.length % 8 != 0) {
            throw new NullPointerException(Resources.getMessage("223"));
        }
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray2, 0, byArray4, 0, 8);
        System.arraycopy(byArray2, 8, byArray3, 0, 8);
        PBES1.convertDESKey(byArray4);
        GenericKey genericKey = new GenericKey(byArray4, "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)genericKey, byArray3);
        byArray = cipher.update(byArray);
        byte by = byArray[byArray.length - 1];
        byte[] byArray5 = new byte[byArray.length - by];
        System.arraycopy(byArray, 0, byArray5, 0, byArray5.length);
        return byArray5;
    }

    private static byte[] doEncrypt(String string, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        byte by = (byte)(byArray.length % 8 == 0 ? 8 : 8 - byArray.length % 8);
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        byte[] byArray5 = new byte[8];
        byte[] byArray6 = new byte[byArray.length + by];
        for (int i = 0; i < 8; ++i) {
            byArray5[i] = by;
        }
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray2, 8, byArray4, 0, 8);
        PBES1.convertDESKey(byArray3);
        GenericKey genericKey = new GenericKey(byArray3, "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, (Key)genericKey, byArray4);
        System.arraycopy(byArray, 0, byArray6, 0, byArray.length);
        System.arraycopy(byArray5, 0, byArray6, byArray.length, by);
        return cipher.update(byArray6);
    }

    private static void convertDESKey(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < 7; ++j) {
                if ((byArray[i] >> j + 1 & 1) == 0) continue;
                ++n;
            }
            if (!(n & true)) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | 1);
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] & 0xFE);
        }
    }
}

