/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs7;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Tag;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.pkcs.pkcs7.SignedData;

public class ContentInfo
extends ASN1Sequence {
    public static final int CONTENT_TAG = ASN1Tag.getExplicitTag((byte)0);
    private ASN1OID contentType = new ASN1OID();
    private ASN1Type content = null;

    public ASN1OID getContentType() {
        return this.contentType;
    }

    public ASN1Type getContent() {
        return this.content;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.contentType.decode(aSN1InputStream);
        String string = this.contentType.toString();
        if (aSN1InputStream.eof()) {
            this.content = null;
        } else {
            if (string.equals("1.2.840.113549.1.7.1")) {
                this.content = new ASN1OctetString();
            } else if (string.equals("1.2.840.113549.1.7.2")) {
                this.content = new SignedData();
            } else {
                throw new ASN1ParsingException(Resources.getMessage("224"));
            }
            this.content.setExplicitTag(CONTENT_TAG);
            this.content.decode(aSN1InputStream);
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        if (this.content == null) {
            throw new ASN1EncodingException(Resources.getMessage("225"));
        }
        this.contentType.encode(aSN1OutputStream);
        this.content.encode(aSN1OutputStream);
    }
}

