/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs7;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Tag;
import com.certicom.security.pkcs.pkcs7.ContentInfo;
import com.certicom.security.pkcs.pkcs7.DigestAlgorithmIdentifiers;
import com.certicom.security.pkcs.pkcs7.ExtendedCertificateOrCertificate;
import com.certicom.security.pkcs.pkcs7.ExtendedCertificatesAndCertificates;
import com.certicom.security.pkcs.pkcs7.SignerInfos;
import com.certicom.security.pkix.Certificate;
import java.util.Vector;

public class SignedData
extends ASN1Sequence {
    public static final byte CERTIFICATES_TAG = ASN1Tag.getImplicitTag((byte)0);
    public static final byte CRLS_TAG = ASN1Tag.getImplicitTag((byte)1);
    private ASN1Integer version = new ASN1Integer();
    private DigestAlgorithmIdentifiers digestAlgIds = new DigestAlgorithmIdentifiers();
    private ContentInfo contentInfo = new ContentInfo();
    private ExtendedCertificatesAndCertificates certificates;
    private SignerInfos signerInfos = new SignerInfos();

    public SignedData() {
        this.certificates = new ExtendedCertificatesAndCertificates();
        this.certificates.setImplicitTag(CERTIFICATES_TAG);
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public Vector getCertificates() {
        Vector<Certificate> vector = new Vector<Certificate>();
        for (int i = 0; i < this.certificates.size(); ++i) {
            Certificate certificate = ((ExtendedCertificateOrCertificate)this.certificates.getItem(i)).getCertificate();
            if (certificate == null) continue;
            vector.addElement(certificate);
        }
        return vector;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.version.decode(aSN1InputStream);
        this.digestAlgIds.decode(aSN1InputStream);
        this.contentInfo.decode(aSN1InputStream);
        int n = aSN1InputStream.peekTag();
        if (n == CERTIFICATES_TAG) {
            this.certificates.decode(aSN1InputStream);
            n = aSN1InputStream.peekTag();
        }
        if (n == CRLS_TAG) {
            throw new ASN1ParsingException(Resources.getMessage("226"));
        }
        this.signerInfos.decode(aSN1InputStream);
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        throw new ASN1EncodingException(Resources.getMessage("227"));
    }
}

