/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkcs.pkcs8;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.DERInputStream;
import com.certicom.security.asn1.RawInputStream;
import com.certicom.security.pkcs.pkcs1.DSSParams;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.sslplus.DSAPrivateKey;
import com.certicom.tls.provider.KeyFactory;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;

public class PrivateKeyInfo
extends ASN1Sequence {
    ASN1Integer version = new ASN1Integer(ASN1Integer.ZERO);
    AlgorithmIdentifier algId;
    ASN1OctetString privateKey;

    public PrivateKeyInfo() {
        this.algId = new AlgorithmIdentifier();
        this.privateKey = new ASN1OctetString();
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.algId = algorithmIdentifier;
        this.privateKey = new ASN1OctetString(byArray);
    }

    public byte[] getRawKey() {
        return this.privateKey.toByteArray();
    }

    public PrivateKey getPrivateKey() {
        try {
            String string = this.algId.getAlgorithm();
            byte[] byArray = this.encode();
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            String string2 = null;
            if (string.equalsIgnoreCase("DSA")) {
                string2 = "dsa_pkcs8";
            } else if (string.equalsIgnoreCase("ECDSA")) {
                string2 = "pkcs8";
            }
            return keyFactory.createPrivateKey(byArray, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public AlgorithmIdentifier getAlgId() {
        return this.algId;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.version.decode(aSN1InputStream);
        this.algId.decode(aSN1InputStream);
        if (aSN1InputStream.peekTag() == 4) {
            this.privateKey.decode(aSN1InputStream);
        } else {
            RawInputStream rawInputStream = new RawInputStream(aSN1InputStream);
            this.privateKey = new ASN1OctetString();
            byte[] byArray = rawInputStream.readBytes(aSN1InputStream.available());
            this.privateKey.setBufferTo(byArray);
        }
        if (!aSN1InputStream.eof()) {
            throw new ASN1ParsingException(Resources.getMessage("228"));
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.version.encode(aSN1OutputStream);
        this.algId.encode(aSN1OutputStream);
        this.privateKey.encode(aSN1OutputStream);
    }

    public DSAPrivateKeySpec getDSAKeySpec() {
        DSAPrivateKeySpec dSAPrivateKeySpec = null;
        try {
            if (this.algId.getParameters().tag() == 16) {
                DSAParams dSAParams = ((DSSParams)this.algId.getParameters()).getParams();
                DERInputStream dERInputStream = new DERInputStream(this.privateKey.toByteArray());
                ASN1Integer aSN1Integer = new ASN1Integer();
                aSN1Integer.decode(dERInputStream);
                dSAPrivateKeySpec = new DSAPrivateKeySpec(new BigInteger(aSN1Integer.toByteArray()), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            } else if (this.algId.getParameters().tag() == 5) {
                DERInputStream dERInputStream = new DERInputStream(this.privateKey.toByteArray());
                DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
                dSAPrivateKey.decode(dERInputStream);
                dSAPrivateKeySpec = dSAPrivateKey.getKey();
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            WeblogicHandler.debugEaten(aSN1ParsingException);
            dSAPrivateKeySpec = null;
        }
        return dSAPrivateKeySpec;
    }
}

