/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Null;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.pkcs.pkcs1.DSSParams;
import com.certicom.security.pkcs.pkcs5.PBEParameter;
import java.security.interfaces.DSAParams;

public class AlgorithmIdentifier
extends ASN1Sequence {
    ASN1OID oid;
    ASN1Type params;

    public AlgorithmIdentifier() {
        this.oid = new ASN1OID();
        this.params = new ASN1Null();
    }

    public AlgorithmIdentifier(String string, ASN1Type aSN1Type) throws ASN1ParsingException {
        this.oid = new ASN1OID(string);
        this.params = aSN1Type == null ? new ASN1Null() : aSN1Type;
    }

    public AlgorithmIdentifier(ASN1OID aSN1OID) {
        this.oid = aSN1OID;
        this.params = new ASN1Null();
    }

    public ASN1OID getOID() {
        return this.oid;
    }

    public ASN1Type getParameters() {
        return this.params;
    }

    public String getAlgorithm() {
        String string = this.oid.toString();
        String string2 = string.equals("1.2.840.113549.1.1.1") ? "RSA" : (string.equals("1.2.840.113549.1.1.4") ? "MD5withRSA" : (string.equals("1.2.840.113549.1.1.2") ? "MD2withRSA" : (string.equals("1.2.840.113549.1.1.5") ? "SHA1withRSA" : (string.equals("1.3.132.2.0") || string.equals("1.2.840.10045.2.1") ? "ECDSA" : (string.equals("1.2.840.10045.4.1") ? "ECDSA" : (string.equals("1.2.840.10040.4.1") ? "DSA" : (string.equals("1.2.840.10040.4.3") ? "SHA/DSA" : (string.equals("1.2.840.113549.1.5.3") ? "MD5/DES-CBC" : null))))))));
        return string2;
    }

    public DSAParams getDSAParams() {
        if (this.params != null && this.params instanceof DSSParams) {
            return ((DSSParams)this.params).getParams();
        }
        return null;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.oid.decode(aSN1InputStream);
        String string = this.oid.toString();
        this.params = null;
        if (string.equals("1.2.840.10040.4.1")) {
            this.params = aSN1InputStream.peekTag() == 5 ? new ASN1Null() : new DSSParams();
        } else if (string.equals("1.3.132.2.0") || string.equals("1.2.840.10045.2.1")) {
            this.params = new ASN1OID();
        } else if (string.equals("1.2.840.113549.1.1.2") || string.equals("1.2.840.113549.1.1.1") || string.equals("1.2.840.113549.1.1.4") || string.equals("1.2.840.113549.1.1.5") || string.equals("1.2.840.10040.4.3") || string.equals("1.2.840.10045.4.1")) {
            this.params = new ASN1Null();
        } else if (string.equals("1.2.840.113549.1.5.3")) {
            this.params = new PBEParameter();
        } else {
            throw new ASN1ParsingException(Resources.getMessage("229") + string);
        }
        if (aSN1InputStream.peekTag() == this.params.tag()) {
            this.params.decode(aSN1InputStream);
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.oid.encode(aSN1OutputStream);
        this.params.encode(aSN1OutputStream);
    }
}

