/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1BMPString;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1IA5String;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1PrintableString;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1String;
import com.certicom.security.asn1.ASN1TeletextString;
import com.certicom.security.asn1.UTF8String;

public class AttributeTypeAndValue
extends ASN1Sequence {
    private ASN1OID type;
    private ASN1String value;

    public AttributeTypeAndValue() {
        this.type = new ASN1OID();
        this.value = null;
    }

    public AttributeTypeAndValue(String string, String string2) throws ASN1ParsingException {
        String string3 = null;
        if ("C".equalsIgnoreCase(string) || "COUNTRY".equalsIgnoreCase(string)) {
            this.value = new ASN1PrintableString();
            string3 = "2.5.4.6";
        } else if ("ST".equalsIgnoreCase(string) || "STATE".equalsIgnoreCase(string)) {
            string3 = "2.5.4.8";
            this.value = new ASN1PrintableString();
        } else if ("L".equalsIgnoreCase(string) || "LOCATION".equalsIgnoreCase(string)) {
            string3 = "2.5.4.7";
            this.value = new ASN1PrintableString();
        } else if ("O".equalsIgnoreCase(string) || "ORGANIZATION".equalsIgnoreCase(string)) {
            string3 = "2.5.4.10";
            this.value = new ASN1TeletextString();
        } else if ("OU".equalsIgnoreCase(string) || "ORGANIZATIONAL UNIT".equalsIgnoreCase(string)) {
            string3 = "2.5.4.11";
            this.value = new ASN1TeletextString();
        } else if ("CN".equalsIgnoreCase(string) || "COMMON NAME".equalsIgnoreCase(string)) {
            string3 = "2.5.4.3";
            this.value = new ASN1TeletextString();
        } else if ("EMAIL".equalsIgnoreCase(string)) {
            string3 = "1.2.840.113549.1.9.1";
            this.value = new ASN1IA5String();
        } else if ("DC".equalsIgnoreCase(string)) {
            string3 = "0.9.2342.19200300.100.1.25";
            this.value = new ASN1IA5String();
        } else {
            this.value = new ASN1TeletextString();
        }
        this.value.setValue(string2);
        this.type = new ASN1OID(string3);
    }

    public ASN1OID getType() {
        return this.type;
    }

    public ASN1String getValue() {
        return this.value;
    }

    public String getValueString() {
        return this.value.getString();
    }

    public String toString() {
        return this.getTypeString() + this.getValueString();
    }

    public String getTypeString() {
        String string = this.type.toString();
        String string2 = string.equals("2.5.4.6") ? "C=" : (string.equals("2.5.4.8") ? "ST=" : (string.equals("2.5.4.7") ? "L=" : (string.equals("2.5.4.10") ? "O=" : (string.equals("2.5.4.11") ? "OU=" : (string.equals("2.5.4.3") ? "CN=" : (string.equals("1.2.840.113549.1.9.1") ? "EMAIL=" : (string.equals("0.9.2342.19200300.100.1.25") ? "DC=" : "?=")))))));
        return string2;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.type.decode(aSN1InputStream);
        int n = aSN1InputStream.peekTag();
        if (n == 19) {
            this.value = new ASN1PrintableString();
        } else if (n == 20) {
            this.value = new ASN1TeletextString();
        } else if (n == 22) {
            this.value = new ASN1IA5String();
        } else if (n == 12) {
            this.value = new UTF8String();
        } else if (n == 30) {
            this.value = new ASN1BMPString();
        } else {
            throw new ASN1ParsingException(Resources.getMessage("230") + n);
        }
        this.value.decode(aSN1InputStream);
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.type.encode(aSN1OutputStream);
        this.value.encode(aSN1OutputStream);
    }
}

