/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.security.asn1.ASN1Boolean;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;

public class BasicConstraints
extends ASN1Sequence {
    public static final boolean CA_DEFAULT = false;
    private ASN1Boolean cA = new ASN1Boolean(false);
    private ASN1Integer pathLen = null;

    public boolean isCA() {
        return this.cA.toBoolean();
    }

    public int getPathLen() {
        if (!this.isCA()) {
            return -1;
        }
        if (this.pathLen == null && this.isCA()) {
            return Integer.MAX_VALUE;
        }
        if (this.pathLen == null) {
            return -1;
        }
        return this.pathLen.toBigInteger().intValue();
    }

    public boolean hasPathLen() {
        return this.pathLen != null;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        if (aSN1InputStream.peekTag() == 1) {
            this.cA.decode(aSN1InputStream);
        } else {
            this.cA = new ASN1Boolean(false);
        }
        if (aSN1InputStream.peekTag() == 2) {
            this.pathLen = new ASN1Integer();
            this.pathLen.decode(aSN1InputStream);
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        if (this.cA.toBoolean()) {
            this.cA.encode(aSN1OutputStream);
        }
        if (this.pathLen != null) {
            this.pathLen.encode(aSN1OutputStream);
        }
    }
}

