/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.pkix.Extensions;
import com.certicom.security.pkix.Name;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.security.pkix.TBSCertificate;
import com.certicom.security.pkix.Validity;
import java.math.BigInteger;

public class Certificate
extends ASN1Sequence {
    private TBSCertificate tbsCertificate = new TBSCertificate();
    private AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier();
    private ASN1BitString signature = new ASN1BitString();
    private byte[] rawTBSCertificate = null;

    public byte[] getSignedData() {
        return this.rawTBSCertificate;
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCertificate;
    }

    public int getVersion() {
        return this.tbsCertificate.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.tbsCertificate.getSerialNumber();
    }

    public AlgorithmIdentifier getSignatureAlgorithmId() {
        return this.sigAlgId;
    }

    public byte[] getSignatureBytes() {
        return this.signature.toByteArray();
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgId.getAlgorithm();
    }

    public String getSignatureAlgOID() {
        return this.sigAlgId.getOID().toString();
    }

    public Name getIssuer() {
        return this.tbsCertificate.getIssuer();
    }

    public Name getSubject() {
        return this.tbsCertificate.getSubject();
    }

    public Validity getValidity() {
        return this.tbsCertificate.getValidity();
    }

    public SubjectPublicKeyInfo getPublicKeyInfo() {
        return this.tbsCertificate.getPublicKeyInfo();
    }

    public Extensions getExtensions() {
        return this.tbsCertificate.getExtensions();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSerialNumber().toString();
        String string2 = this.getIssuer().toString();
        String string3 = this.getSubject().toString();
        String string4 = this.getValidity().getStart().getTime().toString();
        String string5 = this.getValidity().getExpiration().getTime().toString();
        String string6 = this.getSignatureAlgorithm();
        String string7 = System.getProperty("line.separator");
        stringBuffer.append(Resources.getMessage("177") + " " + string + string7);
        stringBuffer.append(Resources.getMessage("178") + string2 + string7);
        stringBuffer.append(Resources.getMessage("179") + string3 + string7);
        stringBuffer.append(Resources.getMessage("180") + string4 + string7);
        stringBuffer.append(Resources.getMessage("181") + string5 + string7);
        stringBuffer.append(Resources.getMessage("182") + string6 + string7);
        return stringBuffer.toString();
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.disableKeepReadBytes();
        aSN1InputStream.enableKeepReadBytes();
        this.tbsCertificate.decode(aSN1InputStream);
        this.rawTBSCertificate = aSN1InputStream.getKeptBytes();
        aSN1InputStream.disableKeepReadBytes();
        this.sigAlgId.decode(aSN1InputStream);
        this.signature.decode(aSN1InputStream);
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        if (this.rawTBSCertificate != null) {
            aSN1OutputStream.write(this.rawTBSCertificate, 0, this.rawTBSCertificate.length);
        } else {
            this.tbsCertificate.encode(aSN1OutputStream);
        }
        this.sigAlgId.encode(aSN1OutputStream);
        this.signature.encode(aSN1OutputStream);
    }
}

