/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.security.asn1.ASN1Boolean;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OID;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;

public class Extension
extends ASN1Sequence {
    public static final boolean CRITICAL_DEFAULT = false;
    private ASN1OID extOid = new ASN1OID();
    private ASN1Boolean critical = new ASN1Boolean(false);
    private ASN1OctetString extValue = new ASN1OctetString();

    public ASN1OID getOID() {
        return this.extOid;
    }

    public boolean isCritical() {
        return this.critical.toBoolean();
    }

    public byte[] getValue() {
        return this.extValue.toByteArray();
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.extOid.decode(aSN1InputStream);
        if (aSN1InputStream.peekTag() == this.critical.tag()) {
            this.critical.decode(aSN1InputStream);
        } else {
            this.critical = new ASN1Boolean(false);
        }
        this.extValue.decode(aSN1InputStream);
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.extOid.encode(aSN1OutputStream);
        if (this.isCritical()) {
            this.critical.encode(aSN1OutputStream);
        }
        this.extValue.encode(aSN1OutputStream);
    }
}

