/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1SequenceOf;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.pkix.BasicConstraints;
import com.certicom.security.pkix.ExtendedKeyUsage;
import com.certicom.security.pkix.Extension;
import com.certicom.security.pkix.KeyUsage;
import java.util.Vector;

public class Extensions
extends ASN1SequenceOf {
    public Extensions() {
        super(new Extension());
    }

    public Extension getExtension(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            ASN1Type aSN1Type = this.getItem(i);
            if (aSN1Type == null || !(aSN1Type instanceof Extension) || !string.equals(((Extension)aSN1Type).getOID().toString())) continue;
            return (Extension)aSN1Type;
        }
        return null;
    }

    public Vector getCriticalExtensionOIDs() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Extension extension = (Extension)this.getItem(i);
            if (!extension.isCritical()) continue;
            if (WeblogicHandler.noStringExtensions()) {
                vector.addElement(extension.getOID());
                continue;
            }
            vector.addElement(extension.getOID().toString());
        }
        return vector;
    }

    public Vector getNonCriticalExtensionOIDs() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Extension extension = (Extension)this.getItem(i);
            if (extension.isCritical()) continue;
            if (WeblogicHandler.noStringExtensions()) {
                vector.addElement(extension.getOID());
                continue;
            }
            vector.addElement(extension.getOID().toString());
        }
        return vector;
    }

    public BasicConstraints getBasicConstraints() throws ASN1ParsingException {
        Extension extension = this.getExtension("2.5.29.19");
        if (extension == null) {
            return null;
        }
        BasicConstraints basicConstraints = new BasicConstraints();
        basicConstraints.decode(extension.getValue());
        return basicConstraints;
    }

    public KeyUsage getKeyUsage() throws ASN1ParsingException {
        Extension extension = this.getExtension("2.5.29.15");
        if (extension == null) {
            return null;
        }
        KeyUsage keyUsage = new KeyUsage();
        keyUsage.decode(extension.getValue());
        return keyUsage;
    }

    public ExtendedKeyUsage getExtendedKeyUsage() throws ASN1ParsingException {
        Extension extension = this.getExtension("2.5.29.37");
        if (extension == null) {
            return null;
        }
        ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage();
        extendedKeyUsage.decode(extension.getValue());
        return extendedKeyUsage;
    }
}

