/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.security.asn1.ASN1BitString;

public class KeyUsage
extends ASN1BitString {
    public static final int DIGITAL_SIGNATURE = Integer.MIN_VALUE;
    public static final int NON_REPUDIATION = 0x40000000;
    public static final int KEY_ENCIPHERMENT = 0x20000000;
    public static final int DATA_ENCIPHERMENT = 0x10000000;
    public static final int KEY_AGREEMENT = 0x8000000;
    public static final int KEY_CERT_SIGN = 0x4000000;
    public static final int CRL_SIGN = 0x2000000;
    public static final int ENCIPHER_ONLY = 0x1000000;
    public static final int DECIPHER_ONLY = 0x800000;
    private boolean stringConverted = false;
    private int bits = 0;

    public int getBits() {
        if (!this.stringConverted) {
            this.convertByteArrayToBitString();
            this.stringConverted = true;
        }
        return this.bits;
    }

    private void convertByteArrayToBitString() {
        byte[] byArray = this.toByteArray();
        this.bits = 0;
        if (byArray != null) {
            int n;
            for (n = 0; n < byArray.length && n < 4; ++n) {
                this.bits <<= 8;
                this.bits |= byArray[n] & 0xFF;
            }
            while (n < 4) {
                this.bits <<= 8;
                ++n;
            }
        }
    }
}

