/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1SequenceOf;
import com.certicom.security.pkix.AttributeTypeAndValue;
import com.certicom.security.pkix.RelativeDistinguishedName;

public class RDNSequence
extends ASN1SequenceOf {
    public RDNSequence() {
        super(new RelativeDistinguishedName());
    }

    public RDNSequence(String string) throws ASN1ParsingException {
        this();
        RelativeDistinguishedName relativeDistinguishedName;
        char[] cArray = string.toCharArray();
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{cArray.length};
        while ((relativeDistinguishedName = RDNSequence.parseNameComp(cArray, nArray, nArray2)) != null) {
            this.addItem(relativeDistinguishedName);
            nArray[0] = nArray[0] + 1;
        }
    }

    public RDNSequence(String[] stringArray, String[] stringArray2) throws ASN1ParsingException {
        this();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] == null || stringArray2[i].length() <= 0) continue;
            this.addItem(new RelativeDistinguishedName(stringArray[i], stringArray2[i]));
        }
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer(20 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getItem(i).toString()).append(", ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    private static final RelativeDistinguishedName parseNameComp(char[] cArray, int[] nArray, int[] nArray2) throws ASN1ParsingException {
        AttributeTypeAndValue attributeTypeAndValue;
        RelativeDistinguishedName relativeDistinguishedName = new RelativeDistinguishedName();
        while ((attributeTypeAndValue = RDNSequence.parseAttribute(cArray, nArray, nArray2)) != null) {
            relativeDistinguishedName.addItem(attributeTypeAndValue);
            if (nArray[0] >= nArray2[0] || cArray[nArray[0]] != '+') break;
            nArray[0] = nArray[0] + 1;
        }
        return relativeDistinguishedName.size() > 0 ? relativeDistinguishedName : null;
    }

    private static final AttributeTypeAndValue parseAttribute(char[] cArray, int[] nArray, int[] nArray2) throws ASN1ParsingException {
        String string = RDNSequence.parseKey(cArray, nArray, nArray2);
        if (string == null) {
            return null;
        }
        nArray[0] = nArray[0] + 1;
        String string2 = RDNSequence.parseValue(cArray, nArray, nArray2);
        return new AttributeTypeAndValue(string, string2);
    }

    private static final String parseKey(char[] cArray, int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray2[0];
        for (n = nArray[0]; n < n2 && Character.isWhitespace(cArray[n]); ++n) {
        }
        if (n >= n2) {
            return null;
        }
        int n3 = n;
        while (n < n2 && cArray[n] != '=' && cArray[n] != ';' && cArray[n] != ',' && cArray[n] != '+') {
            ++n;
        }
        if (n >= n2 || cArray[n] != '=') {
            throw new IllegalArgumentException(Resources.getMessage("231"));
        }
        nArray[0] = n--;
        while (n > n3 && Character.isWhitespace(cArray[n])) {
            --n;
        }
        return new String(cArray, n3, n - n3 + 1);
    }

    private static final String parseValue(char[] cArray, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        boolean bl;
        int n3;
        int n4 = nArray2[0];
        for (n3 = nArray[0]; n3 < n4 && Character.isWhitespace(cArray[n3]); ++n3) {
        }
        if (n3 >= n4) {
            nArray[0] = n3;
            return null;
        }
        boolean bl2 = bl = cArray[n3] == '\u0012';
        if (bl) {
            n2 = ++n3;
            while (n3 < n4 && cArray[n3] != '\u0012') {
                if (cArray[n3] == '\\') {
                    System.arraycopy(cArray, n3 + 1, cArray, n3, --n4 - n3);
                }
                ++n3;
            }
            if (n3 >= n4) {
                throw new IllegalArgumentException(Resources.getMessage("232"));
            }
            n = n3++;
            while (n3 < n4 && Character.isWhitespace(cArray[n3])) {
                ++n3;
            }
        } else {
            n2 = n3;
            int n5 = -1;
            while (n3 < n4 && cArray[n3] != ',' && cArray[n3] != ';' && cArray[n3] != '+') {
                if (cArray[n3] == '\\') {
                    System.arraycopy(cArray, n3 + 1, cArray, n3, --n4 - n3);
                    if (cArray[n3] == ' ') {
                        n5 = n3;
                    }
                }
                ++n3;
            }
            for (n = n3 - 1; n > n5 && Character.isWhitespace(cArray[n]); --n) {
            }
            ++n;
        }
        nArray[0] = n3;
        nArray2[0] = n4;
        if (n <= n2) {
            return null;
        }
        return new String(cArray, n2, n - n2);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + this.size() * 20);
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.getItem(i).toString()).append(", ");
        }
        if (stringBuffer.length() > n) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }
}

