/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.DERInputStream;
import com.certicom.security.pkcs.pkcs1.DSSParams;
import com.certicom.security.pkix.AlgorithmIdentifier;
import java.math.BigInteger;
import java.security.spec.DSAPublicKeySpec;

public class SubjectPublicKeyInfo
extends ASN1Sequence {
    AlgorithmIdentifier algId;
    ASN1BitString publicKey;

    public SubjectPublicKeyInfo() {
        this.algId = new AlgorithmIdentifier();
        this.publicKey = new ASN1BitString();
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.algId = algorithmIdentifier;
        this.publicKey = new ASN1BitString(byArray);
    }

    public byte[] getKey() {
        return this.publicKey.toByteArray();
    }

    public AlgorithmIdentifier getAlgId() {
        return this.algId;
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.algId.decode(aSN1InputStream);
        this.publicKey.decode(aSN1InputStream);
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.algId.encode(aSN1OutputStream);
        this.publicKey.encode(aSN1OutputStream);
    }

    public DSAPublicKeySpec getDSAKeySpec() {
        DSAPublicKeySpec dSAPublicKeySpec = null;
        try {
            DSSParams dSSParams = (DSSParams)this.algId.getParameters();
            DERInputStream dERInputStream = new DERInputStream(this.publicKey.toByteArray());
            ASN1Integer aSN1Integer = new ASN1Integer();
            aSN1Integer.decode(dERInputStream);
            dSAPublicKeySpec = new DSAPublicKeySpec(new BigInteger(aSN1Integer.toByteArray()), dSSParams.getP(), dSSParams.getQ(), dSSParams.getG());
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            // empty catch block
        }
        return dSAPublicKeySpec;
    }
}

