/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.pkix;

import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1BitString;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Tag;
import com.certicom.security.pkix.AlgorithmIdentifier;
import com.certicom.security.pkix.Extensions;
import com.certicom.security.pkix.Name;
import com.certicom.security.pkix.SubjectPublicKeyInfo;
import com.certicom.security.pkix.Validity;
import java.math.BigInteger;

public class TBSCertificate
extends ASN1Sequence {
    public static final byte VERSION_TAG = ASN1Tag.getExplicitTag((byte)0);
    public static final byte ISSUER_ID_TAG = ASN1Tag.getImplicitTag((byte)1);
    public static final byte SUBJECT_ID_TAG = ASN1Tag.getImplicitTag((byte)2);
    public static final byte EXTENSIONS_TAG = ASN1Tag.getExplicitTag((byte)3);
    private static final BigInteger X509V1 = BigInteger.valueOf(0L);
    private static final BigInteger X509V2 = BigInteger.valueOf(1L);
    private static final BigInteger X509V3 = BigInteger.valueOf(2L);
    private ASN1Integer version = new ASN1Integer(ASN1Integer.ZERO);
    private ASN1Integer serialNumber;
    private AlgorithmIdentifier signature;
    private Name issuer;
    private Validity validity;
    private Name subject;
    private SubjectPublicKeyInfo keyInfo;
    private ASN1BitString issuerUniqueId = null;
    private ASN1BitString subjectUniqueId = null;
    private Extensions extensions = null;

    public TBSCertificate() {
        this.version.setExplicitTag(VERSION_TAG);
        this.serialNumber = new ASN1Integer();
        this.signature = new AlgorithmIdentifier();
        this.issuer = new Name();
        this.validity = new Validity();
        this.subject = new Name();
        this.keyInfo = new SubjectPublicKeyInfo();
    }

    public int getVersion() {
        return this.version.toBigInteger().intValue();
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber.toBigInteger();
    }

    public AlgorithmIdentifier getSignatureAlg() {
        return this.signature;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getPublicKeyInfo() {
        return this.keyInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        if (aSN1InputStream.peekTag() == VERSION_TAG) {
            this.version.decode(aSN1InputStream);
        } else {
            this.version = new ASN1Integer(ASN1Integer.ZERO);
            this.version.setExplicitTag(VERSION_TAG);
        }
        this.serialNumber.decode(aSN1InputStream);
        this.signature.decode(aSN1InputStream);
        this.issuer.decode(aSN1InputStream);
        this.validity.decode(aSN1InputStream);
        this.subject.decode(aSN1InputStream);
        this.keyInfo.decode(aSN1InputStream);
        if (aSN1InputStream.peekTag() == ISSUER_ID_TAG) {
            this.issuerUniqueId = new ASN1BitString();
            this.issuerUniqueId.setImplicitTag(ISSUER_ID_TAG);
            this.issuerUniqueId.decode(aSN1InputStream);
        }
        if (aSN1InputStream.peekTag() == SUBJECT_ID_TAG) {
            this.subjectUniqueId = new ASN1BitString();
            this.subjectUniqueId.setImplicitTag(SUBJECT_ID_TAG);
            this.subjectUniqueId.decode(aSN1InputStream);
        }
        if (aSN1InputStream.peekTag() == EXTENSIONS_TAG) {
            if (!this.version.toBigInteger().equals(X509V3)) {
                throw new ASN1ParsingException(Resources.getMessage("233"));
            }
            this.extensions = new Extensions();
            this.extensions.setExplicitTag(EXTENSIONS_TAG);
            this.extensions.decode(aSN1InputStream);
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        if (!this.version.equals(ASN1Integer.ZERO)) {
            this.version.encode(aSN1OutputStream);
        }
        this.serialNumber.encode(aSN1OutputStream);
        this.signature.encode(aSN1OutputStream);
        this.issuer.encode(aSN1OutputStream);
        this.validity.encode(aSN1OutputStream);
        this.subject.encode(aSN1OutputStream);
        this.keyInfo.encode(aSN1OutputStream);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.setImplicitTag(ISSUER_ID_TAG);
            this.issuerUniqueId.encode(aSN1OutputStream);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.setImplicitTag(SUBJECT_ID_TAG);
            this.subjectUniqueId.encode(aSN1OutputStream);
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            if (!this.version.toBigInteger().equals(X509V3)) {
                throw new ASN1EncodingException(Resources.getMessage("233"));
            }
            this.extensions.setExplicitTag(EXTENSIONS_TAG);
            this.extensions.encode(aSN1OutputStream);
        }
    }
}

