/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.sslplus;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1Integer;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.pkcs.pkcs1.DSSParams;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;

public class DSAPrivateKey
extends ASN1Sequence {
    DSSParams params;
    ASN1Integer x;

    public DSAPrivateKey() {
        this.params = new DSSParams();
        this.x = new ASN1Integer();
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.params = new DSSParams(bigInteger, bigInteger2, bigInteger3);
        this.x = new ASN1Integer(bigInteger4);
    }

    public DSAPrivateKey(DSAPrivateKeySpec dSAPrivateKeySpec) {
        this.params = new DSSParams(dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG());
        this.x = new ASN1Integer(dSAPrivateKeySpec.getX());
    }

    public DSAPrivateKey(DSAParams dSAParams, BigInteger bigInteger) {
        this.params = new DSSParams(dSAParams);
        this.x = new ASN1Integer(bigInteger);
    }

    public DSAPrivateKeySpec getKey() {
        return new DSAPrivateKeySpec(this.x.toBigInteger(), this.params.getP(), this.params.getQ(), this.params.getG());
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.params.decode(aSN1InputStream);
        this.x.decode(aSN1InputStream);
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.params.encode(aSN1OutputStream);
        this.x.encode(aSN1OutputStream);
    }
}

