/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.sslplus;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OctetString;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.pkcs.pkcs5.PBEParameter;
import com.certicom.security.pkcs.pkcs5.PBES1;
import com.certicom.security.pkix.AlgorithmIdentifier;
import java.util.Random;

public class EncryptedPrivateKey
extends ASN1Sequence {
    public static final int defaultIterationCount = 5;
    private AlgorithmIdentifier algId;
    private ASN1OctetString encryptedKey;

    public EncryptedPrivateKey() {
        this.algId = new AlgorithmIdentifier();
        this.encryptedKey = new ASN1OctetString();
    }

    public EncryptedPrivateKey(byte[] byArray, String string, Random random) {
        this(byArray, string, random, 5);
    }

    public EncryptedPrivateKey(byte[] byArray, String string, Random random, int n) {
        PBES1 pBES1 = new PBES1("MD5/DES-CBC", byArray, string, random, n);
        try {
            PBEParameter pBEParameter = pBES1.getParameters();
            this.algId = new AlgorithmIdentifier("1.2.840.113549.1.5.3", pBEParameter);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            WeblogicHandler.debugEaten(aSN1ParsingException);
        }
        this.encryptedKey = new ASN1OctetString(pBES1.getEncryptedMessage());
    }

    public byte[] getPrivateKey(String string) {
        byte[] byArray = this.encryptedKey.toByteArray();
        PBEParameter pBEParameter = (PBEParameter)this.algId.getParameters();
        PBES1 pBES1 = new PBES1("MD5/DES-CBC", byArray, string, pBEParameter);
        return pBES1.getPlainMessage();
    }

    public void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.algId.decode(aSN1InputStream);
        this.encryptedKey.decode(aSN1InputStream);
    }

    public void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        this.algId.encode(aSN1OutputStream);
        this.encryptedKey.encode(aSN1OutputStream);
    }
}

