/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls;

import com.certicom.io.InputSSLIO;
import com.certicom.io.InputSSLIOStream;
import com.certicom.io.OutputSSLIO;
import com.certicom.io.OutputSSLIOStream;
import com.certicom.net.ssl.TrustManager;
import com.certicom.tls.TLSConnection;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.ciphersuite.SecurityParameters;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public final class TLSContext {
    protected TLSSystem system = new TLSSystem();

    public void setHelloProtocol(String string) throws IllegalArgumentException {
        this.system.setHelloProtocol(string);
    }

    public void setTrustManager(TrustManager trustManager) {
        this.system.getCertificateSupport().setTrustManager(trustManager);
    }

    public void setTrustManager(TrustManager trustManager, Object object) {
        this.system.getCertificateSupport().setTrustManager(trustManager);
        this.system.getCertificateSupport().setCertificateCallbackRef(object);
    }

    public void disableDefaultTrustedCertificates() {
        this.system.getCertificateSupport().disableDefaultTrustedCertificates();
    }

    public void addRSAExportKey(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException {
        this.system.getCertificateSupport().addRSAExportKey(keyPair);
        this.system.resetCipherSuiteSupport();
    }

    public KeyPair generateRSAExportKey(int n, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        return this.system.getCertificateSupport().generateRSAExportKey(n, secureRandom);
    }

    public void addAuthChain(X509Certificate[] x509CertificateArray, byte[] byArray) {
        this.system.getCertificateSupport().addAuthChain(x509CertificateArray, byArray);
    }

    public void addAuthChain(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this.system.getCertificateSupport().addAuthChain(x509CertificateArray, privateKey);
        this.system.resetCipherSuiteSupport();
    }

    public void removeAuthChain(X509Certificate x509Certificate) {
        this.system.getCertificateSupport().removeAuthChain(x509Certificate);
        this.system.resetCipherSuiteSupport();
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) throws CertificateException {
        this.system.getCertificateSupport().addTrustedCertificate(x509Certificate);
    }

    public void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        this.system.getCertificateSupport().loadLocalIdentity(inputStream, cArray);
        this.system.resetCipherSuiteSupport();
    }

    public void loadTrustedCertificates(InputStream inputStream) throws KeyManagementException {
        this.system.getCertificateSupport().loadTrustedCertificates(inputStream);
    }

    public void setRNG(SecureRandom secureRandom) {
        TLSSystem.setRandomNumberGenerator(secureRandom);
    }

    public void setSessionDB(TLSSessionDB tLSSessionDB) {
        this.system.setSessionDB(tLSSessionDB);
    }

    public void setIsExportedLimited(boolean bl) {
        this.system.setIsExportedLimited(bl);
    }

    public void setIsStrongCipherSuiteLimited(boolean bl) {
        this.system.setIsStrongCipherSuiteLimited(bl);
    }

    public void setServerGatedCryptoEnabled(boolean bl) {
        this.system.setServerGatedCryptoEnabled(bl);
    }

    public String getHelloProtocol() {
        return this.system.getHelloProtocol();
    }

    public X509Certificate[] getAuthChain(String string, int n) {
        return this.system.getCertificateSupport().getAuthChain(string, n);
    }

    public void setX509BasicConstraintBug(boolean bl) {
        TLSSystem.setX509BasicConstraintBug(bl);
    }

    public boolean getX509BasicConstraintBug() {
        return TLSSystem.getX509BasicConstraintBug();
    }

    public String[] getSupportedCipherSuites() {
        TLSContext tLSContext = this;
        return tLSContext.system.getSupportedCipherSuites();
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.system.setEnabledCipherSuites(stringArray);
    }

    public String[] getEnabledCipherSuites() {
        return this.system.getAuthenticatedEnabledCipherSuites();
    }

    public TLSConnection getClientConnection(InputStream inputStream, OutputStream outputStream, Serializable serializable) {
        return this.getClientConnection(new InputSSLIOStream(inputStream), new OutputSSLIOStream(outputStream), serializable);
    }

    public TLSConnection getClientConnection(InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable) {
        return this.system.createClient(inputSSLIO, outputSSLIO, serializable);
    }

    public TLSConnection getServerConnection(InputStream inputStream, OutputStream outputStream, Serializable serializable) {
        return this.getServerConnection(new InputSSLIOStream(inputStream), new OutputSSLIOStream(outputStream), serializable);
    }

    public TLSConnection getServerConnection(InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable) {
        return this.system.createServer(inputSSLIO, outputSSLIO, serializable);
    }

    public static byte[] PRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws NoSuchAlgorithmException {
        return SecurityParameters.TLS_PRF(byArray, byArray2, byArray3, n);
    }

    public void setWriteFragmentLength(int n) {
        this.system.setWriteFragmentLength(n);
    }

    public static synchronized void setMaxHandshakeMessageLength(int n) throws IllegalArgumentException {
        TLSSystem.setMaxHandshakeMessageLength(n);
    }

    public static synchronized int getMaxHandshakeMessageLength() {
        return TLSSystem.getMaxHandshakeMessageLength();
    }

    public void installMobileTrustCertificates() {
        this.system.getCertificateSupport().installDefaultTrustedCertificates();
    }

    public void setAcceptEmptyCertRequest(boolean bl) {
        TLSSystem.setAcceptEmptyCertRequest(bl);
    }

    public boolean getAcceptEmptyCertRequest() {
        return TLSSystem.getAcceptEmptyCertRequest();
    }

    public void setSendEmptyCertRequest(boolean bl) {
        TLSSystem.setSendEmptyCertRequest(bl);
    }

    public boolean getSendEmptyCertRequest() {
        return TLSSystem.getSendEmptyCertRequest();
    }
}

