/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.ciphersuite;

import com.certicom.tls.ciphersuite.CryptoNames;
import java.io.Serializable;

public final class CipherSuite
implements Serializable,
Cloneable,
CryptoNames {
    private String description;
    private int tag;
    private boolean exportable;
    private String cipherAlgorithm;
    private String macAlgorithm;
    private int keyAgreementAlgorithm;
    private String certificateType;
    private int cipherKeyMaterialLength;
    private int cipherKeyLength;

    CipherSuite(String string, int n, String string2, String string3, String string4, int n2, int n3, int n4, boolean bl) {
        this.description = string;
        this.keyAgreementAlgorithm = n;
        this.cipherAlgorithm = string2;
        this.macAlgorithm = string3;
        this.certificateType = string4;
        this.tag = n2;
        this.cipherKeyMaterialLength = n3;
        this.cipherKeyLength = n4;
        this.exportable = bl;
    }

    public CipherSuite() {
        this.description = "TLS_NULL_WITH_NULL_NULL";
        this.keyAgreementAlgorithm = 0;
        this.cipherAlgorithm = "NullCipher";
        this.macAlgorithm = "NullMac";
        this.tag = 0;
        this.exportable = true;
    }

    public int getCipherKeyLength() {
        return this.cipherKeyLength;
    }

    public int getCipherKeyMaterialLength() {
        return this.cipherKeyMaterialLength;
    }

    public String getDescription() {
        return this.description;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public int getKeyAgreementAlgorithm() {
        return this.keyAgreementAlgorithm;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public boolean equals(Object object) {
        if (object instanceof CipherSuite) {
            CipherSuite cipherSuite = (CipherSuite)object;
            return this.equals(((CipherSuite)object).description);
        }
        if (object instanceof String) {
            return this.description.equals((String)object);
        }
        return false;
    }

    public String toString() {
        return this.description;
    }
}

