/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.ciphersuite;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuites;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.KeyAgreement;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.Signature;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public final class CipherSuiteSupport
implements CryptoNames,
CipherSuites {
    private static final Boolean VALUE = new Boolean(true);
    private static boolean haveECDSA;
    private static boolean haveDSA;
    private static boolean haveRSASignature;
    private static boolean haveDH;
    private static boolean haveECDH;
    private static boolean haveDESede;
    private static boolean haveRSACipher;
    private static boolean haveDES;
    private static boolean haveRC4;
    private static boolean haveAES;
    private static boolean haveRSA512Key;
    private static boolean haveRSA1024Key;
    private static CipherSuite[] cipherSuites;
    private static final boolean disableNullCipher;
    private static boolean allowUnencryptedNullCipher;

    public static synchronized String[] getCipherSuiteNames() {
        String[] stringArray = new String[cipherSuites.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = cipherSuites[i].getDescription();
        }
        return stringArray;
    }

    public static synchronized void enableUnencryptedNullCipher(boolean bl) {
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "SSL enableUnencryptedNullCipher= " + bl, null);
        }
        boolean bl2 = allowUnencryptedNullCipher;
        allowUnencryptedNullCipher = bl;
        CipherSuiteSupport.isUnEncrytedNullCipherAllowed();
        if (bl2 != bl) {
            CipherSuiteSupport.loadCipherSuites();
        }
    }

    public static synchronized boolean isUnEncrytedNullCipherAllowed() {
        if (disableNullCipher) {
            if (allowUnencryptedNullCipher) {
                throw new IllegalArgumentException("Can not start SSL due to conflicting configuration - System configure parameter of weblogic.security.disableNullCipher = true, and configure parameter weblogic.security.ssl.allowUnencryptedNullCipher = true");
            }
            return false;
        }
        return allowUnencryptedNullCipher;
    }

    public static synchronized CipherSuite[] getCipherSuites() {
        return cipherSuites;
    }

    public static synchronized CipherSuite getCipherSuite(int n) throws NoSuchAlgorithmException {
        for (int i = 0; i < cipherSuites.length; ++i) {
            CipherSuite cipherSuite = cipherSuites[i];
            int n2 = cipherSuites[i].getTag();
            if (n != n2) continue;
            return cipherSuites[i];
        }
        throw new NoSuchAlgorithmException();
    }

    public static synchronized boolean isSupported(String string) {
        try {
            CipherSuiteSupport.getCipherSuite(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            return false;
        }
        return true;
    }

    public static synchronized CipherSuite getCipherSuite(String string) throws NoSuchAlgorithmException {
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (!cipherSuites[i].getDescription().equals(string)) continue;
            return cipherSuites[i];
        }
        throw new NoSuchAlgorithmException();
    }

    public static synchronized CipherSuite getCipherSuite(InputStream inputStream, ProtocolVersion protocolVersion) throws IOException, NoSuchAlgorithmException {
        int n = protocolVersion.equals(ProtocolVersions.SSL20) ? inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read() : inputStream.read() << 8 | inputStream.read();
        return CipherSuiteSupport.getCipherSuite(n);
    }

    public static synchronized void reset() {
        haveECDSA = false;
        haveRSASignature = false;
        haveDSA = false;
        haveDH = false;
        haveECDH = false;
        haveRSACipher = false;
        haveDES = false;
        haveDESede = false;
        haveRC4 = false;
        haveRSA512Key = false;
        haveRSA1024Key = false;
        haveAES = false;
        CipherSuiteSupport.checkCryptography();
        CipherSuiteSupport.loadCipherSuites();
    }

    public static synchronized boolean isCryptoAlgAvail(String string) {
        if (string.equals("SHA1withDSA")) {
            return haveDSA;
        }
        if (string.equals("ECDSA")) {
            return haveECDSA;
        }
        if (string.equals("RSA_SIGNATURE")) {
            return haveRSASignature;
        }
        return false;
    }

    private static synchronized void checkCryptography() {
        try {
            MessageDigest.getInstance("SHA");
            MessageDigest.getInstance("MD5");
            Mac.getInstance("HmacSHA1");
            Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            return;
        }
        try {
            Signature.getInstance("ECDSA");
            haveECDSA = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Signature.getInstance("SHA1withDSA");
            haveDSA = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Signature.getInstance("MD2withRSA");
            Signature.getInstance("MD5withRSA");
            Signature.getInstance("SHA1withRSA");
            haveRSASignature = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            KeyAgreement.getInstance("DiffieHellman");
            haveDH = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            KeyAgreement.getInstance("ECDH");
            haveECDH = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Cipher.getInstance("DESede");
            haveDESede = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Cipher.getInstance("DES");
            haveDES = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Cipher.getInstance("AES");
            haveAES = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Cipher.getInstance("RC4");
            haveRC4 = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        try {
            Cipher.getInstance("RSA/ECB/PKCS1Padding");
            Cipher.getInstance("RSA/ECB/NoPadding");
            haveRSACipher = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
    }

    private static synchronized void loadCipherSuites() {
        Vector<CipherSuite> vector = new Vector<CipherSuite>();
        if (haveRC4) {
            if (haveRSACipher) {
                vector.addElement(TLS_RSA_WITH_RC4_128_MD5);
                vector.addElement(TLS_RSA_WITH_RC4_128_SHA);
            }
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_WITH_RC4_128_SHA);
            }
            if (haveECDH && haveECDSA) {
                vector.addElement(TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
            }
            if (haveECDH && haveRSASignature) {
                vector.addElement(TLS_ECDH_RSA_WITH_RC4_128_SHA);
            }
        }
        if (haveAES) {
            if (haveRSACipher) {
                vector.addElement(TLS_RSA_WITH_AES_128_CBC_SHA);
                vector.addElement(TLS_RSA_WITH_AES_256_CBC_SHA);
            }
            if (haveECDH && haveECDSA) {
                vector.addElement(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
                vector.addElement(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
            }
        }
        if (haveDESede) {
            if (haveRSACipher) {
                vector.addElement(TLS_RSA_WITH_3DES_EDE_CBC_SHA);
            }
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
            }
            if (haveDH && haveRSASignature) {
                vector.addElement(TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
            }
            if (haveECDH && haveECDSA) {
                vector.addElement(TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA);
            }
            if (haveECDH && haveRSASignature) {
                vector.addElement(TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA);
            }
        }
        if (haveDES) {
            if (haveRSACipher) {
                vector.addElement(TLS_RSA_WITH_DES_CBC_SHA);
            }
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_WITH_DES_CBC_SHA);
            }
            if (haveDH && haveRSASignature) {
                vector.addElement(TLS_DHE_RSA_WITH_DES_CBC_SHA);
            }
            if (haveECDH && haveECDSA) {
                vector.addElement(TLS_ECDH_ECDSA_WITH_DES_CBC_SHA);
            }
            if (haveECDH && haveRSASignature) {
                vector.addElement(TLS_ECDH_RSA_WITH_DES_CBC_SHA);
            }
        }
        if (haveRC4) {
            if (haveRSACipher && haveRSASignature) {
                vector.addElement(TLS_RSA_EXPORT1024_WITH_RC4_56_SHA);
            }
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA);
            }
        }
        if (haveDES) {
            if (haveRSACipher && haveRSASignature) {
                vector.addElement(TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA);
            }
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA);
            }
        }
        if (haveRC4 && haveRSACipher && haveRSASignature) {
            vector.addElement(TLS_RSA_EXPORT_WITH_RC4_40_MD5);
        }
        if (haveDES) {
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
            }
            if (haveDH && haveRSASignature) {
                vector.addElement(TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
            }
        }
        if (haveDES && haveRSACipher && haveRSASignature) {
            vector.addElement(TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
        }
        if (CipherSuiteSupport.isUnEncrytedNullCipherAllowed()) {
            if (haveRSACipher) {
                vector.addElement(TLS_RSA_WITH_NULL_MD5);
                vector.addElement(TLS_RSA_WITH_NULL_SHA);
            }
            if (haveECDH && haveECDSA) {
                vector.addElement(TLS_ECDH_ECDSA_WITH_NULL_SHA);
            }
        }
        if (haveDH) {
            if (haveDESede) {
                vector.addElement(TLS_DH_anon_WITH_3DES_EDE_CBC_SHA);
            }
            if (haveRC4) {
                vector.addElement(TLS_DH_anon_WITH_RC4_128_MD5);
            }
            if (haveDES) {
                vector.addElement(TLS_DH_anon_WITH_DES_CBC_SHA);
            }
        }
        if (haveDH) {
            if (haveRC4) {
                vector.addElement(TLS_DH_anon_EXPORT_WITH_RC4_40_MD5);
            }
            if (haveDES) {
                vector.addElement(TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
            }
        }
        if (haveDES) {
            if (haveDH && haveDSA) {
                vector.addElement(TLS_DHE_DSS_EXPORT_WITH_DES_40_CBC_SHA);
            }
            if (haveDH && haveRSASignature) {
                vector.addElement(TLS_DHE_RSA_EXPORT_WITH_DES_40_CBC_SHA);
            }
        }
        if (haveDES && haveRSACipher && haveRSASignature) {
            vector.addElement(TLS_RSA_EXPORT_WITH_DES_40_CBC_SHA);
        }
        if (haveDH && haveDES) {
            vector.addElement(TLS_DH_anon_EXPORT_WITH_DES_40_CBC_SHA);
        }
        cipherSuites = new CipherSuite[vector.size()];
        vector.copyInto(cipherSuites);
    }

    static {
        disableNullCipher = Boolean.getBoolean("weblogic.security.disableNullCipher");
        allowUnencryptedNullCipher = Boolean.getBoolean("weblogic.ssl.AllowUnencryptedNullCipher");
    }
}

