/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.ciphersuite;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.CryptoLabels;
import com.certicom.tls.provider.Mac;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.spec.GenericKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public final class SecurityParameters
implements CryptoLabels,
CryptoNames,
ProtocolVersions {
    private byte[] readMacSecret;
    private byte[] writeMacSecret;
    private byte[] readCipherSecret;
    private byte[] writeCipherSecret;
    private byte[] readIV;
    private byte[] writeIV;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private int challengeLength;
    private final int KeyMaterialLength = 16;
    private Vector KeyMaterials;
    private byte[] masterSecret;
    private CipherSuite cipherSuite;
    private ProtocolVersion protocolVersion;

    public SecurityParameters(CipherSuite cipherSuite, byte[] byArray, byte[] byArray2, byte[] byArray3, ProtocolVersion protocolVersion, boolean bl) throws NoSuchAlgorithmException {
        this.masterSecret = byArray;
        this.cipherSuite = cipherSuite;
        this.protocolVersion = protocolVersion;
        this.clientRandom = byArray2;
        this.serverRandom = byArray3;
        this.deriveKeys(byArray2, byArray3, bl);
    }

    public SecurityParameters(CipherSuite cipherSuite, byte[] byArray, byte[] byArray2, byte[] byArray3, ProtocolVersion protocolVersion, int n, boolean bl) throws NoSuchAlgorithmException {
        this.masterSecret = byArray;
        this.cipherSuite = cipherSuite;
        this.protocolVersion = protocolVersion;
        this.clientRandom = byArray2;
        this.serverRandom = byArray3;
        this.challengeLength = n;
        if (!protocolVersion.equals(SSL20)) {
            throw new NoSuchAlgorithmException();
        }
        this.makeSSL2Keys(bl);
    }

    public Cipher createReadCipher() throws NoSuchAlgorithmException {
        String string = this.cipherSuite.getCipherAlgorithm();
        Cipher cipher = Cipher.getInstance(string);
        if (string.startsWith("DES")) {
            SecurityParameters.convertDESKey(this.readCipherSecret);
        }
        cipher.init(2, (Key)new GenericKey(this.readCipherSecret, string), this.readIV);
        return cipher;
    }

    public Cipher createWriteCipher() throws NoSuchAlgorithmException {
        String string = this.cipherSuite.getCipherAlgorithm();
        Cipher cipher = Cipher.getInstance(string);
        if (string.startsWith("DES")) {
            SecurityParameters.convertDESKey(this.writeCipherSecret);
        }
        cipher.init(1, (Key)new GenericKey(this.writeCipherSecret, string), this.writeIV);
        return cipher;
    }

    public String getCipherAlgorithm() {
        return this.cipherSuite.getCipherAlgorithm();
    }

    private static void convertDESKey(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < 7; ++j) {
                if ((byArray[i] >> j + 1 & 1) == 0) continue;
                ++n;
            }
            if (!(n & true)) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | 1);
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] & 0xFE);
        }
    }

    public Mac createReadMac() throws NoSuchAlgorithmException {
        try {
            Mac mac = this.getMac();
            mac.init(new GenericKey((byte[])this.readMacSecret.clone()));
            return mac;
        }
        catch (InvalidKeyException invalidKeyException) {
            WeblogicHandler.debugEaten(invalidKeyException);
            return null;
        }
    }

    public Mac createWriteMac() throws NoSuchAlgorithmException {
        try {
            Mac mac = this.getMac();
            mac.init(new GenericKey((byte[])this.writeMacSecret.clone()));
            return mac;
        }
        catch (InvalidKeyException invalidKeyException) {
            WeblogicHandler.debugEaten(invalidKeyException);
            return null;
        }
    }

    private Mac getMac() throws NoSuchAlgorithmException {
        String string = this.cipherSuite.getMacAlgorithm();
        Mac mac = null;
        if (this.protocolVersion.equals(TLS10)) {
            if (string.equals("SHA")) {
                string = "HMACSHA1";
            } else if (string.equals("MD5")) {
                string = "HMACMD5";
            }
            mac = Mac.getInstance(string);
        } else if (this.protocolVersion.equals(SSL30)) {
            if (string.equals("SHA")) {
                mac = Mac.getInstance("SSL3MAC_SHA");
            } else if (string.equals("MD5")) {
                mac = Mac.getInstance("SSL3MAC_MD5");
            }
        } else if (this.protocolVersion.equals(SSL20)) {
            if (string.equals("SHA")) {
                mac = Mac.getInstance("SSL2MAC_SHA");
            } else if (string.equals("MD5")) {
                mac = Mac.getInstance("SSL2MAC_MD5");
            }
        }
        return mac;
    }

    public void forget() {
    }

    private static byte[] SSL3_PRF_ITERATION(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
        int n2 = 65 + n;
        byte[] byArray4 = new byte[n + 1];
        for (int i = 0; i <= n; ++i) {
            byArray4[i] = (byte)n2;
        }
        messageDigest2.update(byArray4);
        messageDigest2.update(byArray);
        messageDigest2.update(byArray2);
        messageDigest2.update(byArray3);
        messageDigest.update(byArray);
        return messageDigest.digest(messageDigest2.digest());
    }

    public static byte[] SSL3_PRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws NoSuchAlgorithmException {
        byte[] byArray4 = new byte[n];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n + 16);
        try {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                byteArrayOutputStream.write(SecurityParameters.SSL3_PRF_ITERATION(byArray, byArray2, byArray3, n3));
                n2 += 16;
                ++n3;
            }
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray4, 0, n);
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
        return byArray4;
    }

    public static byte[] TLS_PRF(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) throws NoSuchAlgorithmException {
        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
        return SecurityParameters.TLS_PRF(byArray, byArray2, byArray5, n);
    }

    public static byte[] TLS_PRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws NoSuchAlgorithmException {
        int n2 = byArray.length / 2;
        int n3 = 0;
        n3 = byArray.length % 2 == 0 ? n2 : n2 + 1;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        System.arraycopy(byArray, n2, byArray5, 0, n3);
        GenericKey genericKey = new GenericKey(byArray4);
        GenericKey genericKey2 = new GenericKey(byArray5);
        Mac mac = Mac.getInstance("HmacMD5");
        Mac mac2 = Mac.getInstance("HmacSHA1");
        try {
            mac.init(genericKey);
            mac2.init(genericKey2);
        }
        catch (InvalidKeyException invalidKeyException) {
            WeblogicHandler.debugEaten(invalidKeyException);
        }
        byte[] byArray6 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray6, byArray2.length, byArray3.length);
        byte[] byArray7 = SecurityParameters.p_hash(mac, byArray6, n);
        byte[] byArray8 = SecurityParameters.p_hash(mac2, byArray6, n);
        byte[] byArray9 = new byte[n];
        for (int i = 0; i < byArray9.length; ++i) {
            byArray9[i] = (byte)(byArray7[i] ^ byArray8[i]);
        }
        return byArray9;
    }

    private static byte[] p_hash(Mac mac, byte[] byArray, int n) {
        int n2 = mac.getMacLength();
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3 * n2);
        byte[] byArray2 = (byte[])byArray.clone();
        for (int i = 0; i < n3; ++i) {
            try {
                byArray2 = mac.doFinal(byArray2);
                mac.update(byArray2);
                byteArrayOutputStream.write(mac.doFinal(byArray));
                continue;
            }
            catch (IOException iOException) {
                WeblogicHandler.debugEaten(iOException);
                System.out.println(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private final void deriveKeys(byte[] byArray, byte[] byArray2, boolean bl) throws NoSuchAlgorithmException {
        byte[][] byArray3 = this.makeKeys(byArray, byArray2);
        if (this.cipherSuite.isExportable()) {
            this.makeKeysExportable(byArray3, byArray, byArray2);
        }
        this.assignKeys(byArray3, bl);
    }

    private final void makeKeysExportable(byte[][] byArray, byte[] byArray2, byte[] byArray3) throws NoSuchAlgorithmException {
        int n = Cipher.getInstance(this.cipherSuite.getCipherAlgorithm()).getBlockSize();
        int n2 = this.cipherSuite.getCipherKeyLength();
        if (this.protocolVersion.equals(TLS10)) {
            byArray[2] = SecurityParameters.TLS_PRF(byArray[2], CLIENT_WRITE_KEY, byArray2, byArray3, n2);
            byArray[3] = SecurityParameters.TLS_PRF(byArray[3], SERVER_WRITE_KEY, byArray2, byArray3, n2);
            byte[] byArray4 = SecurityParameters.TLS_PRF(new byte[0], IV_BLOCK, byArray2, byArray3, 2 * n);
            System.arraycopy(byArray4, 0, byArray[4], 0, n);
            System.arraycopy(byArray4, n, byArray[5], 0, n);
        } else if (this.protocolVersion.equals(SSL30)) {
            int n3 = this.cipherSuite.getCipherKeyLength();
            byte[] byArray5 = new byte[n3];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray[2]);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            if (this.cipherSuite.getCipherAlgorithm().equals("DES")) {
                System.arraycopy(messageDigest.digest(), 0, byArray5, 0, this.cipherSuite.getCipherKeyLength());
                byArray[2] = byArray5;
            } else {
                byArray[2] = messageDigest.digest();
            }
            messageDigest.update(byArray[3]);
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            byArray5 = new byte[n3];
            if (this.cipherSuite.getCipherAlgorithm().equals("DES")) {
                System.arraycopy(messageDigest.digest(), 0, byArray5, 0, this.cipherSuite.getCipherKeyLength());
                byArray[3] = byArray5;
            } else {
                byArray[3] = messageDigest.digest();
            }
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            if (this.cipherSuite.getCipherAlgorithm().equals("DES")) {
                System.arraycopy(messageDigest.digest(), 0, byArray[4], 0, n);
            } else {
                byArray[4] = messageDigest.digest();
            }
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            if (this.cipherSuite.getCipherAlgorithm().equals("DES")) {
                System.arraycopy(messageDigest.digest(), 0, byArray[5], 0, n);
            } else {
                byArray[5] = messageDigest.digest();
            }
        } else {
            throw new NoSuchAlgorithmException();
        }
    }

    private final void makeSSL2Keys(boolean bl) throws NoSuchAlgorithmException {
        this.KeyMaterials = new Vector();
        int n = this.cipherSuite.getCipherKeyLength();
        int n2 = Cipher.getInstance(this.cipherSuite.getCipherAlgorithm()).getBlockSize();
        String string = this.cipherSuite.getMacAlgorithm();
        byte by = 48;
        byte[] byArray = new byte[this.challengeLength];
        System.arraycopy(this.clientRandom, this.clientRandom.length - this.challengeLength, byArray, 0, this.challengeLength);
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.masterSecret);
        messageDigest.update(by);
        messageDigest.update(byArray);
        messageDigest.update(this.serverRandom);
        byte[] byArray2 = messageDigest.digest();
        this.addKeyMaterial(byArray2);
        by = (byte)(by + 1);
        MessageDigest messageDigest2 = MessageDigest.getInstance(string);
        messageDigest2.update(this.masterSecret);
        messageDigest2.update(by);
        messageDigest2.update(byArray);
        messageDigest2.update(this.serverRandom);
        byte[] byArray3 = messageDigest2.digest();
        this.addKeyMaterial(byArray3);
        this.readCipherSecret = new byte[n];
        this.writeCipherSecret = new byte[n];
        this.writeMacSecret = new byte[n];
        this.readMacSecret = new byte[n];
        if (bl) {
            System.arraycopy(byArray2, 0, this.readCipherSecret, 0, n);
            System.arraycopy(byArray3, 0, this.writeCipherSecret, 0, n);
        } else {
            System.arraycopy(byArray3, 0, this.readCipherSecret, 0, n);
            System.arraycopy(byArray2, 0, this.writeCipherSecret, 0, n);
        }
        System.arraycopy(this.writeCipherSecret, 0, this.writeMacSecret, 0, n);
        System.arraycopy(this.readCipherSecret, 0, this.readMacSecret, 0, n);
        if (n2 != 0) {
            this.readIV = new byte[n2];
            this.writeIV = new byte[n2];
            System.arraycopy(this.masterSecret, n, this.readIV, 0, n2);
            System.arraycopy(this.masterSecret, n, this.writeIV, 0, n2);
        }
    }

    private final byte[][] makeKeys(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = Mac.getInstance(this.cipherSuite.getMacAlgorithm()).getMacLength();
        n2 = this.cipherSuite.getCipherKeyMaterialLength();
        n3 = Cipher.getInstance(this.cipherSuite.getCipherAlgorithm()).getBlockSize();
        n4 = 2 * n + 2 * n2 + 2 * n3;
        byte[] byArray3 = null;
        if (this.protocolVersion.equals(TLS10)) {
            byArray3 = SecurityParameters.TLS_PRF(this.masterSecret, KEY_EXPANSION, byArray2, byArray, n4);
        } else if (this.protocolVersion.equals(SSL30)) {
            byArray3 = SecurityParameters.SSL3_PRF(this.masterSecret, byArray2, byArray, n4);
        } else {
            throw new NoSuchAlgorithmException();
        }
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        byte[] byArray8 = new byte[n3];
        byte[] byArray9 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        System.arraycopy(byArray3, n, byArray5, 0, n);
        System.arraycopy(byArray3, 2 * n, byArray6, 0, n2);
        System.arraycopy(byArray3, 2 * n + n2, byArray7, 0, n2);
        System.arraycopy(byArray3, 2 * n + 2 * n2, byArray8, 0, n3);
        System.arraycopy(byArray3, 2 * n + 2 * n2 + n3, byArray9, 0, n3);
        return new byte[][]{byArray4, byArray5, byArray6, byArray7, byArray8, byArray9};
    }

    public byte[][] getKeyMaterial() {
        byte[][] byArray = new byte[this.KeyMaterials.size()][16];
        for (int i = 0; i < this.KeyMaterials.size(); ++i) {
            byArray[i] = (byte[])this.KeyMaterials.elementAt(i);
        }
        return byArray;
    }

    private void addKeyMaterial(byte[] byArray) {
        this.KeyMaterials.addElement(byArray);
    }

    private final void assignKeys(byte[][] byArray, boolean bl) {
        if (bl) {
            this.readMacSecret = byArray[1];
            this.writeMacSecret = byArray[0];
            this.readCipherSecret = byArray[3];
            this.writeCipherSecret = byArray[2];
            this.readIV = byArray[5];
            this.writeIV = byArray[4];
        } else {
            this.readMacSecret = byArray[0];
            this.writeMacSecret = byArray[1];
            this.readCipherSecret = byArray[2];
            this.writeCipherSecret = byArray[3];
            this.readIV = byArray[4];
            this.writeIV = byArray[5];
        }
    }

    public String toString() {
        return null;
    }
}

