/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.certicom.locale.Resources;
import com.certicom.tls.TLSConnection;
import java.util.EventObject;

public final class AlertEvent
extends EventObject {
    public static final int SSL2_PE_NO_CIPHER = 1;
    public static final int SSL2_PE_NO_CERTIFICATE = 2;
    public static final int SSL2_PE_BAD_CERTIFICATE = 4;
    public static final int SSL2_PE_UNSUPPORTED_CERTIFICATE_TYPE = 6;
    public static final int CLOSE_NOTIFY = 0;
    public static final int UNEXPECTED_MESSAGE = 10;
    public static final int BAD_RECORD_MAC = 20;
    public static final int DECRYPTION_FAILED = 21;
    public static final int RECORD_OVERFLOW = 22;
    public static final int DECOMPRESSION_FAILURE = 30;
    public static final int HANDSHAKE_FAILURE = 40;
    public static final int NO_CERTIFICATE = 41;
    public static final int BAD_CERTIFICATE = 42;
    public static final int UNSUPPORTED_CERTIFICATE = 43;
    public static final int CERTIFICATE_REVOKED = 44;
    public static final int CERTIFICATE_EXPIRED = 45;
    public static final int CERTIFICATE_UNKNOWN = 46;
    public static final int ILLEGAL_PARAMETER = 47;
    public static final int UNKNOWN_CA = 48;
    public static final int ACCESS_DENIED = 49;
    public static final int DECODE_ERROR = 50;
    public static final int DECRYPT_ERROR = 51;
    public static final int EXPORT_RESTRICTION = 60;
    public static final int PROTOCOL_VERSION = 70;
    public static final int INSUFFICIENT_SECURITY = 71;
    public static final int INTERNAL_ERROR = 80;
    public static final int USER_CANCELLED = 90;
    public static final int NO_RENEGOTIATION = 100;
    private boolean fatal;
    private int type;
    private boolean ignored = false;

    public AlertEvent(TLSConnection tLSConnection, boolean bl, int n) {
        super(tLSConnection);
        this.fatal = bl;
        this.type = n;
        this.ignored = !bl;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public int getType() {
        return this.type;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public TLSConnection getConnection() {
        return (TLSConnection)this.source;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fatal) {
            stringBuffer.append(Resources.getMessage("48"));
        } else {
            stringBuffer.append(Resources.getMessage("144"));
        }
        if (this.ignored) {
            stringBuffer.append(Resources.getMessage("50"));
        } else {
            stringBuffer.append(":");
        }
        switch (this.type) {
            case 0: {
                stringBuffer.append(Resources.getMessage("25"));
                break;
            }
            case 10: {
                stringBuffer.append(Resources.getMessage("137"));
                break;
            }
            case 20: {
                stringBuffer.append(Resources.getMessage("9"));
                break;
            }
            case 21: {
                stringBuffer.append(Resources.getMessage("36"));
                break;
            }
            case 22: {
                stringBuffer.append(Resources.getMessage("106"));
                break;
            }
            case 30: {
                stringBuffer.append(Resources.getMessage("35"));
                break;
            }
            case 40: {
                stringBuffer.append(Resources.getMessage("49"));
                break;
            }
            case 42: {
                stringBuffer.append(Resources.getMessage("3"));
                break;
            }
            case 41: {
                stringBuffer.append(Resources.getMessage("73"));
                break;
            }
            case 43: {
                stringBuffer.append(Resources.getMessage("135"));
                break;
            }
            case 44: {
                stringBuffer.append(Resources.getMessage("31"));
                break;
            }
            case 45: {
                stringBuffer.append(Resources.getMessage("28"));
                break;
            }
            case 47: {
                stringBuffer.append(Resources.getMessage("52"));
                break;
            }
            case 48: {
                stringBuffer.append(Resources.getMessage("127"));
                break;
            }
            case 49: {
                stringBuffer.append(Resources.getMessage("0"));
                break;
            }
            case 50: {
                stringBuffer.append(Resources.getMessage("34"));
                break;
            }
            case 51: {
                stringBuffer.append(Resources.getMessage("37"));
                break;
            }
            case 60: {
                stringBuffer.append(Resources.getMessage("46"));
                break;
            }
            case 70: {
                stringBuffer.append(Resources.getMessage("102"));
                break;
            }
            case 71: {
                stringBuffer.append(Resources.getMessage("57"));
                break;
            }
            case 80: {
                stringBuffer.append(Resources.getMessage("59"));
                break;
            }
            case 90: {
                stringBuffer.append(Resources.getMessage("138"));
                break;
            }
            case 100: {
                stringBuffer.append(Resources.getMessage("77"));
                break;
            }
            case 1: {
                stringBuffer.append(Resources.getMessage("244"));
                stringBuffer.append(Resources.getMessage("245"));
                break;
            }
            case 2: {
                stringBuffer.append(Resources.getMessage("244"));
                stringBuffer.append(Resources.getMessage("73"));
                break;
            }
            case 4: {
                stringBuffer.append(Resources.getMessage("244"));
                stringBuffer.append(Resources.getMessage("3"));
                break;
            }
            case 6: {
                stringBuffer.append(Resources.getMessage("244"));
                stringBuffer.append(Resources.getMessage("135"));
                break;
            }
            default: {
                stringBuffer.append(Resources.getMessage("128"));
            }
        }
        return stringBuffer.toString();
    }
}

