/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.bea.sslplus.WeblogicHandler;
import com.bea.sslplus.extensions.CertificatePoliciesImpl;
import com.certicom.locale.Resources;
import com.certicom.net.ssl.TrustManager;
import com.certicom.net.ssl.impl.TrustManagerImpl;
import com.certicom.security.cert.internal.x509.SSLPlusSupport;
import com.certicom.security.cert.internal.x509.X509V3CertImpl;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.provider.Cipher;
import com.certicom.tls.provider.KeyFactory;
import com.certicom.tls.provider.KeyPairGenerator;
import com.certicom.tls.provider.MessageDigest;
import com.certicom.tls.provider.Signature;
import com.certicom.tls.provider.spec.RSAParameters;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import weblogic.security.CertificatePolicy;
import weblogic.security.CertificatePolicyQualifier;
import weblogic.security.utils.SSLHostnameVerifier;
import weblogic.security.utils.SSLSetup;
import weblogic.security.utils.SSLTruster;

public final class CertificateSupport
implements Serializable {
    private Vector trustedCertificates = new Vector();
    private TrustManager trustManager = new TrustManagerImpl();
    private Object certificateCallbackRef = null;
    private Vector rsaAuthChains = new Vector();
    private Vector dsaAuthChains = new Vector();
    private Vector ecdsaAuthChains = new Vector();
    private Vector hybridAuthChains = new Vector();
    private Vector rsaPrivateKeys = new Vector();
    private Vector dsaPrivateKeys = new Vector();
    private Vector ecdsaPrivateKeys = new Vector();
    private Vector hybridPrivateKeys = new Vector();
    private KeyPair rsaEphemeral512;
    private KeyPair rsaEphemeral1024;
    private SSLTruster wlsTruster = null;
    private SSLHostnameVerifier wlsVerifier = null;
    private int exportKeyRefreshCountLimit = -1;
    private int exportKeyRefreshCounter = 0;
    private static Boolean certInitSync = new Boolean(true);
    private static X509V3CertImpl mtEcdsaRootCert = null;
    private static X509V3CertImpl mtRsaRootCert = null;

    public void setWLSTruster(SSLTruster sSLTruster) {
        this.wlsTruster = sSLTruster;
    }

    public SSLTruster getWLSTruster() {
        return this.wlsTruster;
    }

    public void setWLSVerifier(SSLHostnameVerifier sSLHostnameVerifier) {
        this.wlsVerifier = sSLHostnameVerifier;
    }

    public SSLHostnameVerifier getWLSVerifier() {
        return this.wlsVerifier;
    }

    public synchronized void setExportKeyRefreshCountLimit(int n) {
        this.exportKeyRefreshCountLimit = n;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setCertificateCallbackRef(Object object) {
        this.certificateCallbackRef = object;
    }

    public void addRSAExportKey(KeyPair keyPair) throws NoSuchAlgorithmException, InvalidKeyException {
        int n = ((RSAPublicKey)keyPair.getPublic()).getModulus().bitLength();
        if (n > 1024) {
            String string = Resources.getMessage("83");
            throw new InvalidKeyException(string);
        }
        if (n > 512) {
            this.rsaEphemeral1024 = keyPair;
        } else {
            this.rsaEphemeral512 = keyPair;
        }
    }

    public KeyPair getRSAExportKey(int n) {
        KeyPair keyPair;
        block9: {
            keyPair = null;
            if (n > 1024) {
                throw new IllegalArgumentException(Resources.getMessage("43"));
            }
            if (this.exportKeyRefreshCountLimit >= 0) {
                ++this.exportKeyRefreshCounter;
                if (this.exportKeyRefreshCounter >= this.exportKeyRefreshCountLimit) {
                    this.rsaEphemeral1024 = null;
                    this.rsaEphemeral512 = null;
                }
            }
            try {
                if (n > 512) {
                    if (this.rsaEphemeral1024 == null) {
                        this.rsaEphemeral1024 = this.generateRSAExportKey(1024, TLSSystem.getRandomNumberGenerator());
                    }
                } else if (this.rsaEphemeral512 == null) {
                    this.rsaEphemeral512 = this.generateRSAExportKey(512, TLSSystem.getRandomNumberGenerator());
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) break block9;
                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Failed to generate RSA export key", noSuchAlgorithmException);
            }
        }
        keyPair = n > 512 ? this.rsaEphemeral1024 : this.rsaEphemeral512;
        return keyPair;
    }

    public KeyPair generateRSAExportKey(int n, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        RSAParameters rSAParameters = new RSAParameters(n, 65537);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(rSAParameters, secureRandom);
        return keyPairGenerator.genKeyPair();
    }

    public void addAuthChain(X509Certificate[] x509CertificateArray, byte[] byArray) {
        String string = x509CertificateArray[0].getPublicKey().getAlgorithm();
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            privateKey = keyFactory.createPrivateKey(byArray, null);
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
        this.addAuthChain(x509CertificateArray, privateKey);
    }

    public void addAuthChain(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        try {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (x509CertificateArray[i] instanceof X509V3CertImpl) continue;
                x509CertificateArray[i] = new X509V3CertImpl(x509CertificateArray[i].getEncoded());
            }
        }
        catch (CertificateException certificateException) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "Cannot convert identity certificate", certificateException);
            }
            throw new RuntimeException("Cannot convert identity certificate");
        }
        String string = x509CertificateArray[0].getPublicKey().getAlgorithm();
        if (string.indexOf("EC") >= 0) {
            String string2 = x509CertificateArray[0].getSigAlgName();
            if (string2.equals("SHA1withRSA") || string2.equals("MD5withRSA") || string2.equals("MD2withRSA")) {
                this.hybridAuthChains.addElement(x509CertificateArray);
                this.hybridPrivateKeys.addElement(privateKey);
            } else {
                this.ecdsaAuthChains.addElement(x509CertificateArray);
                this.ecdsaPrivateKeys.addElement(privateKey);
            }
        } else if (string.equals("RSA")) {
            this.rsaAuthChains.addElement(x509CertificateArray);
            this.rsaPrivateKeys.addElement(privateKey);
        } else if (string.equals("DSA")) {
            this.dsaAuthChains.addElement(x509CertificateArray);
            this.dsaPrivateKeys.addElement(privateKey);
        }
    }

    public void removeAuthChain(X509Certificate x509Certificate) {
        int n;
        for (n = 0; n < this.rsaAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.rsaAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            this.rsaAuthChains.removeElementAt(n);
            this.rsaPrivateKeys.removeElementAt(n);
            return;
        }
        for (n = 0; n < this.dsaAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.dsaAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            this.dsaAuthChains.removeElementAt(n);
            this.dsaPrivateKeys.removeElementAt(n);
            return;
        }
        for (n = 0; n < this.ecdsaAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.ecdsaAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            this.ecdsaAuthChains.removeElementAt(n);
            this.ecdsaPrivateKeys.removeElementAt(n);
            return;
        }
        for (n = 0; n < this.hybridAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.hybridAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            this.hybridAuthChains.removeElementAt(n);
            this.hybridPrivateKeys.removeElementAt(n);
            return;
        }
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) throws CertificateException {
        if (!(x509Certificate instanceof X509V3CertImpl)) {
            x509Certificate = new X509V3CertImpl(x509Certificate.getEncoded());
        }
        if (x509Certificate.getPublicKey() == null) {
            Principal principal = x509Certificate.getSubjectDN();
            throw new CertificateException("Could not get public key for: " + ((Object)principal).toString());
        }
        this.trustedCertificates.addElement(x509Certificate);
    }

    public void removeTrustedCertificate(X509Certificate x509Certificate) {
        this.trustedCertificates.removeElement(x509Certificate);
    }

    public void installDefaultTrustedCertificates() {
    }

    public void disableDefaultTrustedCertificates() {
        if (mtEcdsaRootCert != null) {
            this.removeTrustedCertificate(mtEcdsaRootCert);
        }
        if (mtRsaRootCert != null) {
            this.removeTrustedCertificate(mtRsaRootCert);
        }
    }

    public boolean isTrustedCertificate(X509Certificate x509Certificate) {
        return this.trustedCertificates.contains(x509Certificate);
    }

    public X509Certificate[] getAuthChain(String string, int n) {
        if (string.equals("ECDSA")) {
            string = "EC";
        }
        try {
            if (string.equals("EC")) {
                if (n < 0 || n >= this.ecdsaAuthChains.size()) {
                    return null;
                }
                return (X509Certificate[])this.ecdsaAuthChains.elementAt(n);
            }
            if (string.equals("RSA")) {
                if (n < 0 || n >= this.rsaAuthChains.size()) {
                    return null;
                }
                return (X509Certificate[])this.rsaAuthChains.elementAt(n);
            }
            if (string.indexOf("DSA") >= 0) {
                if (n < 0 || n >= this.dsaAuthChains.size()) {
                    return null;
                }
                return (X509Certificate[])this.dsaAuthChains.elementAt(n);
            }
            if (string.equals("HYBRID")) {
                if (n < 0 || n >= this.hybridAuthChains.size()) {
                    return null;
                }
                return (X509Certificate[])this.hybridAuthChains.elementAt(n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            WeblogicHandler.debugEaten(arrayIndexOutOfBoundsException);
            return null;
        }
        return null;
    }

    public PrivateKey getPrivateKey(X509Certificate x509Certificate) {
        int n;
        for (n = 0; n < this.rsaAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.rsaAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            return (PrivateKey)this.rsaPrivateKeys.elementAt(n);
        }
        for (n = 0; n < this.dsaAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.dsaAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            return (PrivateKey)this.dsaPrivateKeys.elementAt(n);
        }
        for (n = 0; n < this.ecdsaAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.ecdsaAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            return (PrivateKey)this.ecdsaPrivateKeys.elementAt(n);
        }
        for (n = 0; n < this.hybridAuthChains.size(); ++n) {
            if (!((X509Certificate[])this.hybridAuthChains.elementAt(n))[0].equals(x509Certificate)) continue;
            return (PrivateKey)this.hybridPrivateKeys.elementAt(n);
        }
        return null;
    }

    public final void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        PrivateKey privateKey;
        Vector vector = SSLPlusSupport.getLocalIdentity(inputStream, cArray);
        X509Certificate[] x509CertificateArray = new X509Certificate[vector.size() - 1];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)vector.elementAt(i);
        }
        PublicKey publicKey = ((X509V3CertImpl)vector.elementAt(0)).getPublicKey();
        if (!this.CheckIfKeyMatch(publicKey, privateKey = (PrivateKey)vector.lastElement())) {
            throw new KeyManagementException(Resources.getMessage("3"));
        }
        this.addAuthChain(x509CertificateArray, privateKey);
    }

    public final boolean CheckIfKeyMatch(PublicKey publicKey, PrivateKey privateKey) throws KeyManagementException {
        String string = "Hello, SSLPlus Java Toolkit developed by CERTICOM";
        string = "Hello World";
        byte[] byArray = string.getBytes();
        byte[] byArray2 = ("CT" + System.currentTimeMillis()).getBytes();
        SecureRandom secureRandom = new SecureRandom(byArray2);
        try {
            String string2 = publicKey.getAlgorithm();
            String string3 = privateKey.getAlgorithm();
            if (string2.indexOf("RSA") >= 0) {
                Cipher cipher;
                if (!string3.equalsIgnoreCase("RSA")) {
                    return false;
                }
                try {
                    cipher = Cipher.getInstance("RSA/ECB/NoPadding");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return false;
                }
                int n = (((RSAPrivateKey)privateKey).getModulus().bitLength() + 7) / 8;
                byte[] byArray3 = this.addPKCS1Padding(n, byArray);
                cipher.init(1, (Key)privateKey, secureRandom);
                byte[] byArray4 = cipher.doFinal(byArray3, 0, byArray3.length);
                Cipher cipher2 = cipher;
                cipher2.init(2, (Key)publicKey, secureRandom);
                byte[] byArray5 = cipher2.doFinal(byArray4, 0, byArray4.length);
                byte[] byArray6 = this.removePKCS1Padding(byArray5);
                if (byArray.length != byArray6.length) {
                    return false;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray6[i]) continue;
                    return false;
                }
                return true;
            }
            if (string2.indexOf("DSA") >= 0) {
                if (string3.indexOf("DSA") < 0) {
                    return false;
                }
                BigInteger bigInteger = ((DSAPublicKey)publicKey).getParams().getG();
                BigInteger bigInteger2 = ((DSAPublicKey)publicKey).getParams().getP();
                BigInteger bigInteger3 = ((DSAPublicKey)publicKey).getParams().getQ();
                BigInteger bigInteger4 = ((DSAPrivateKey)privateKey).getParams().getG();
                BigInteger bigInteger5 = ((DSAPrivateKey)privateKey).getParams().getP();
                BigInteger bigInteger6 = ((DSAPrivateKey)privateKey).getParams().getQ();
                if (!bigInteger.equals(bigInteger4)) {
                    return false;
                }
                if (!bigInteger2.equals(bigInteger5)) {
                    return false;
                }
                if (!bigInteger3.equals(bigInteger6)) {
                    return false;
                }
                if (!CipherSuiteSupport.isCryptoAlgAvail("SHA1withDSA")) {
                    return false;
                }
                Signature signature = Signature.getInstance("SHA1withDSA");
                signature.initSign(privateKey, TLSSystem.getRandomNumberGenerator());
                signature.update(byArray);
                byte[] byArray7 = signature.sign();
                Signature signature2 = Signature.getInstance("SHA1withDSA");
                signature2.initVerify(publicKey);
                signature2.update(byArray);
                return signature2.verify(byArray7);
            }
            if (string2.indexOf("EC") >= 0) {
                if (!string3.startsWith("EC")) {
                    return false;
                }
                if (!CipherSuiteSupport.isCryptoAlgAvail("ECDSA")) {
                    return false;
                }
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(byArray2);
                messageDigest.update(byArray);
                byte[] byArray8 = messageDigest.digest();
                Signature signature = Signature.getInstance("ECDSA");
                signature.initSign(privateKey, TLSSystem.getRandomNumberGenerator());
                signature.update(byArray8);
                byte[] byArray9 = signature.sign();
                Signature signature3 = Signature.getInstance("ECDSA");
                signature3.initVerify(publicKey);
                signature3.update(byArray8);
                return signature3.verify(byArray9);
            }
            throw new KeyManagementException(Resources.getMessage("153"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new KeyManagementException(Resources.getMessage("3"));
        }
    }

    public byte[] addPKCS1Padding(int n, byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        if (byArray.length >= n - 3) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        byArray3[n2++] = 0;
        byArray3[n2++] = 1;
        while (n2 < n - byArray.length - 1) {
            byArray3[n2] = -1;
            ++n2;
        }
        byArray3[n2++] = 0;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        return byArray3;
    }

    public byte[] removePKCS1Padding(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        int n = -1;
        if (byArray.length < 4 || byArray[0] != 0) {
            return byArray2;
        }
        switch (byArray[1]) {
            case 1: 
            case 2: {
                for (n = 2; n < byArray.length && byArray[n] != 0; ++n) {
                }
                break;
            }
            default: {
                return byArray2;
            }
        }
        if (n == byArray.length) {
            return byArray2;
        }
        int n2 = n + 1;
        byte[] byArray3 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
        return byArray3;
    }

    public final void loadTrustedCertificates(InputStream inputStream) throws KeyManagementException {
        X509Certificate[] x509CertificateArray = SSLPlusSupport.getTrustedCertificates(inputStream);
        int n = 0;
        String string = "No certs loaded";
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            try {
                this.addTrustedCertificate(x509CertificateArray[i]);
                ++n;
                continue;
            }
            catch (CertificateException certificateException) {
                WeblogicHandler.debugEaten(certificateException);
                string = certificateException.getMessage();
            }
        }
        if (n == 0) {
            throw new KeyManagementException(string);
        }
    }

    public X509Certificate[] getTrustedCertificates() {
        Object[] objectArray = new X509Certificate[this.trustedCertificates.size()];
        this.trustedCertificates.copyInto(objectArray);
        return objectArray;
    }

    public boolean isClientTrusted(X509Certificate[][] x509CertificateArray, String string, ProtocolVersion protocolVersion, Object object, SSLSocket sSLSocket) {
        return this.validateCertificateChain(true, x509CertificateArray, string, protocolVersion, object, sSLSocket);
    }

    public boolean isServerTrusted(X509Certificate[][] x509CertificateArray, String string, ProtocolVersion protocolVersion, Object object, SSLSocket sSLSocket) {
        return this.validateCertificateChain(false, x509CertificateArray, string, protocolVersion, object, sSLSocket);
    }

    public boolean isServerHostnameValid(SSLSocket sSLSocket) {
        String string;
        return this.wlsVerifier == null || this.wlsVerifier.hostnameValidationCallback(string = sSLSocket.getInetAddress().getHostName(), sSLSocket);
    }

    private boolean validateCertificateChain(boolean bl, X509Certificate[][] x509CertificateArray, String string, ProtocolVersion protocolVersion, Object object, SSLSocket sSLSocket) {
        X509Certificate[] x509CertificateArray2 = x509CertificateArray[0];
        X509Certificate[] x509CertificateArray3 = null;
        int n = 0;
        if (x509CertificateArray2 != null && x509CertificateArray2.length != 0) {
            try {
                x509CertificateArray3 = this.completeCertChain(x509CertificateArray2);
            }
            catch (CertificateException certificateException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Cannot complete the certificate chain: " + certificateException.getMessage(), null);
                }
                n |= 0x10;
                x509CertificateArray3 = x509CertificateArray2;
            }
        } else {
            x509CertificateArray3 = x509CertificateArray2;
        }
        x509CertificateArray[0] = x509CertificateArray3;
        if (x509CertificateArray3 == null) {
            if (n == 0) {
                n |= 1;
            }
            if (this.wlsTruster != null) {
                if ((n = this.wlsTruster.validationCallback(x509CertificateArray3, n, sSLSocket, this.getTrustedCertificates())) != 0) {
                    if ((n & 0x40) != 0) {
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Trust failure (" + n + "): " + WeblogicHandler.getErrorName(n), null);
                        }
                        return false;
                    }
                }
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Trust status (" + n + "): " + WeblogicHandler.getErrorName(n), null);
                }
            }
            return this.trustManager.certificateCallback(x509CertificateArray3, n, object != null ? object : this.certificateCallbackRef);
        }
        for (int i = 0; i < x509CertificateArray3.length; ++i) {
            Set<String> set;
            X509Certificate x509Certificate;
            block68: {
                block67: {
                    Principal principal;
                    x509Certificate = x509CertificateArray3[i];
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Validating certificate " + i + " in the chain: " + x509Certificate, null);
                    }
                    Principal principal2 = x509Certificate.getIssuerDN();
                    if (i + 1 != x509CertificateArray3.length && !((Object)(principal = x509CertificateArray3[i + 1].getSubjectDN())).equals(principal2)) {
                        n |= 1;
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Certificate chain is invalid because the issuer DN does not match the next certificate subject: " + principal, null);
                        }
                    }
                    if ((n & 8) == 0) {
                        if ((n & 0x10) == 0 && i + 1 != x509CertificateArray3.length) {
                            try {
                                PublicKey publicKey = x509CertificateArray3[i + 1].getPublicKey();
                                if (publicKey instanceof RSAPublicKey && !WeblogicHandler.isValidRSAPublicExponent((BigInteger)((Object)(set = ((RSAPublicKey)publicKey).getPublicExponent())))) {
                                    n |= 8;
                                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                                        WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Signature verification failed because RSA key public exponent [" + set + "] is too small", null);
                                    }
                                }
                                x509Certificate.verify(publicKey);
                            }
                            catch (Exception exception) {
                                WeblogicHandler.debugEaten(exception);
                                n |= 8;
                                if (!WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) break block67;
                                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Signature verification failed", null);
                            }
                        }
                    }
                }
                if ((n & 2) == 0) {
                    try {
                        x509Certificate.checkValidity();
                    }
                    catch (Exception exception) {
                        WeblogicHandler.debugEaten(exception);
                        n |= 2;
                        if (!WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) break block68;
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Certificate is invalid: " + exception.getMessage(), null);
                    }
                }
            }
            boolean bl2 = false;
            set = x509Certificate.getCriticalExtensionOIDs();
            if (set != null) {
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    String string2 = iterator.next().toString();
                    if (string2.equals("2.5.29.19")) {
                        int n2 = x509Certificate.getBasicConstraints();
                        if (n2 != -1 && n2 != Integer.MAX_VALUE && n2 + 1 < i) {
                            SSLSetup.logCertificateChainPathLenExceededConstraintsFailure(sSLSocket);
                            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed x509 basic constraints check", null);
                            }
                            return false;
                        }
                        if (n2 == -1 && i > 0) {
                            SSLSetup.logCertificateChainNotACaConstraintsFailure(sSLSocket);
                            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed x509 basic constraints check - is not CA", null);
                            }
                            return false;
                        }
                        bl2 = true;
                        continue;
                    }
                    if (string2.equals("2.5.29.15")) {
                        boolean[] blArray = x509Certificate.getKeyUsage();
                        if (blArray == null) continue;
                        if (i == 0) {
                            try {
                                int n3;
                                CipherSuite cipherSuite = CipherSuiteSupport.getCipherSuite(string);
                                int n4 = cipherSuite.getKeyAgreementAlgorithm();
                                if (bl) {
                                    if (!protocolVersion.equals(ProtocolVersions.TLS10) || blArray[0] || n4 == 5 || n4 == 12) continue;
                                    SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                    return false;
                                }
                                if (!blArray[4] && n4 == 5) {
                                    SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                    return false;
                                }
                                if (!blArray[4] && n4 == 12) {
                                    SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                    return false;
                                }
                                if (!blArray[2] && n4 == 6 && protocolVersion.equals(ProtocolVersions.TLS10)) {
                                    SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                    return false;
                                }
                                if (n4 == 7) {
                                    object2 = (RSAPublicKey)x509Certificate.getPublicKey();
                                    n3 = object2.getModulus().bitLength();
                                    if (n3 <= 512 && !blArray[2]) {
                                        SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                        return false;
                                    }
                                    if (n3 <= 512 || blArray[0]) continue;
                                    SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                    return false;
                                }
                                if (n4 == 8) {
                                    object2 = (RSAPublicKey)x509Certificate.getPublicKey();
                                    n3 = object2.getModulus().bitLength();
                                    if (n3 <= 1024 && !blArray[2]) {
                                        SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                        return false;
                                    }
                                    if (n3 <= 1024 || blArray[0]) continue;
                                    SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                    return false;
                                }
                                if (blArray[0] || n4 != 2 && n4 != 3 && n4 != 4) continue;
                                SSLSetup.logCertificateChainAlgKeyUsageFailure(sSLSocket);
                                return false;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                SSLSetup.logCertificateChainCheckKeyUsageFailure(sSLSocket);
                                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                                return false;
                            }
                        }
                        if (blArray[5]) continue;
                        SSLSetup.logCertificateChainCertSignKeyUsageFailure(sSLSocket);
                        return false;
                    }
                    if (string2.equals("2.5.29.37") && i == 0) {
                        List list = null;
                        try {
                            if (x509Certificate instanceof X509V3CertImpl) {
                                list = ((X509V3CertImpl)x509Certificate).getExtendedKeyUsage();
                            }
                        }
                        catch (CertificateParsingException certificateParsingException) {
                            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Caught exception while retrieving extended key usage", certificateParsingException);
                            }
                            return false;
                        }
                        if (list == null) continue;
                        boolean bl3 = false;
                        Iterator iterator2 = list.iterator();
                        while (!bl3 && iterator2.hasNext()) {
                            object2 = (String)iterator2.next();
                            if ((!bl || !((String)object2).equals("1.3.6.1.5.5.7.3.2")) && (bl || !((String)object2).equals("1.3.6.1.5.5.7.3.1"))) continue;
                            bl3 = true;
                        }
                        if (bl3 && (object2 = x509Certificate.getKeyUsage()) != null) {
                            boolean bl4 = bl3 = object2[0] || object2[4] != false || !bl && object2[2] != false;
                        }
                        if (bl3) continue;
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "ExtendedKeyUsage failed the validation check", null);
                        }
                        return false;
                    }
                    if (string2.equals("2.5.29.17")) continue;
                    if (string2.equals("2.5.29.32")) {
                        boolean bl5 = CertificateSupport.processCertificatePolicies(x509Certificate, sSLSocket);
                        if (bl5) continue;
                        return bl5;
                    }
                    SSLSetup.logCertificateChainUnrecognizedExtensionFailure(sSLSocket, string2);
                    return false;
                }
            }
            if (TLSSystem.getX509BasicConstraintBug()) continue;
            if (i > 0 && TLSSystem.getX509NoV1CAs() && x509Certificate.getVersion() == 0) {
                SSLSetup.logCertificateChainNoV1CAFailure(sSLSocket);
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed x509 No V1 CAs check", null);
                }
                return false;
            }
            if (i <= 0 || x509Certificate.getVersion() != 2 || bl2 || !TLSSystem.getX509StrictConstraints() && this.isPathLengthValid(x509Certificate, i)) continue;
            if (TLSSystem.getX509StrictConstraints()) {
                SSLSetup.logCertificateChainConstraintsStrictNonCriticalFailure(sSLSocket);
            } else if (x509Certificate.getExtensionValue("2.5.29.19") == null) {
                SSLSetup.logCertificateChainMissingConstraintsFailure(sSLSocket);
            } else if (x509Certificate.getBasicConstraints() < 0) {
                SSLSetup.logCertificateChainNotACaConstraintsFailure(sSLSocket);
            } else {
                SSLSetup.logCertificateChainPathLenExceededConstraintsFailure(sSLSocket);
            }
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed x509 strict constraints check", null);
            }
            return false;
        }
        if (this.wlsTruster != null) {
            if ((n = this.wlsTruster.validationCallback(x509CertificateArray3, n, sSLSocket, this.getTrustedCertificates())) != 0) {
                if ((n & 0x40) != 0) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Trust failure (" + n + "): " + WeblogicHandler.getErrorName(n), null);
                    }
                    return false;
                }
            }
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Trust status (" + n + "): " + WeblogicHandler.getErrorName(n), null);
            }
        }
        return this.trustManager.certificateCallback(x509CertificateArray3, n, object != null ? object : this.certificateCallbackRef);
    }

    private boolean isPathLengthValid(X509Certificate x509Certificate, int n) {
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 != -1 && n2 != Integer.MAX_VALUE && n2 + 1 < n) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed x509 basic constraints check, pathLen exceeded", null);
            }
            return false;
        }
        if (n2 == -1 && n > 0) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed x509 basic constraints check - is not CA", null);
            }
            return false;
        }
        return true;
    }

    public boolean validateECDSA_fixed_ECDH(boolean bl, X509Certificate[] x509CertificateArray, ProtocolVersion protocolVersion) {
        int n = 16;
        X509Certificate x509Certificate = x509CertificateArray[0];
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        if (set != null) {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (!string.equals("2.5.29.15")) continue;
                boolean[] blArray = x509Certificate.getKeyUsage();
                if (blArray == null) {
                    return true;
                }
                if (protocolVersion.equals(ProtocolVersions.TLS10) && !blArray[4] && bl) {
                    return false;
                }
                return !protocolVersion.equals(ProtocolVersions.TLS10) || blArray[0] || bl;
            }
        }
        return true;
    }

    private X509Certificate[] completeCertChain(X509Certificate[] x509CertificateArray) throws CertificateException {
        int n;
        X509Certificate[] x509CertificateArray2 = this.findInTrusted(x509CertificateArray[0].getSubjectDN());
        if (x509CertificateArray2 != null) {
            for (n = 0; n < x509CertificateArray2.length && x509CertificateArray2[n] != null; ++n) {
                if (!x509CertificateArray2[n].equals(x509CertificateArray[0])) continue;
                return x509CertificateArray;
            }
        }
        for (n = 0; n < x509CertificateArray.length; ++n) {
            x509CertificateArray2 = this.findInTrusted(x509CertificateArray[n].getIssuerDN());
            if (x509CertificateArray2 == null) continue;
            X509Certificate x509Certificate = null;
            if (x509CertificateArray2.length > 1 && x509CertificateArray2[1] != null) {
                for (int i = 0; i < x509CertificateArray2.length && x509CertificateArray2[i] != null; ++i) {
                    try {
                        x509CertificateArray[n].verify(x509CertificateArray2[i].getPublicKey());
                        x509Certificate = x509CertificateArray2[i];
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            } else {
                x509Certificate = x509CertificateArray2[0];
            }
            if (x509Certificate == null) continue;
            X509Certificate[] x509CertificateArray3 = new X509Certificate[n + 2];
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, n + 1);
            x509CertificateArray3[n + 1] = x509Certificate;
            return x509CertificateArray3;
        }
        throw new CertificateException("No trusted cert found");
    }

    private X509Certificate[] appendToCertChain(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray2[i] = x509CertificateArray[i];
        }
        x509CertificateArray2[x509CertificateArray.length] = x509Certificate;
        return x509CertificateArray2;
    }

    private X509Certificate[] replaceCaExpiredCerts(X509Certificate[] x509CertificateArray) {
        for (int i = 1; i < x509CertificateArray.length; ++i) {
            boolean bl = false;
            try {
                x509CertificateArray[i].checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                WeblogicHandler.debugEaten(certificateExpiredException);
                bl = true;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                WeblogicHandler.debugEaten(certificateNotYetValidException);
                bl = true;
            }
            if (!bl) continue;
            x509CertificateArray[i] = this.replaceWithTrusted(x509CertificateArray[i]);
        }
        return x509CertificateArray;
    }

    private X509Certificate replaceWithTrusted(X509Certificate x509Certificate) {
        X509Certificate x509Certificate2 = null;
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCertificates.size()];
        x509CertificateArray = this.findInTrusted(x509Certificate.getSubjectDN());
        if (x509CertificateArray != null) {
            x509Certificate2 = x509CertificateArray[0];
            return x509Certificate2;
        }
        return x509Certificate;
    }

    private X509Certificate[] findInTrusted(Principal principal) {
        X509Certificate[] x509CertificateArray = this.findInTrusted_Validity(principal, true);
        if (x509CertificateArray == null) {
            x509CertificateArray = this.findInTrusted_Validity(principal, false);
        }
        return x509CertificateArray;
    }

    private X509Certificate[] findInTrusted_Validity(Principal principal, boolean bl) {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCertificates.size()];
        Enumeration enumeration = this.trustedCertificates.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate = (X509Certificate)enumeration.nextElement();
            Principal principal2 = x509Certificate.getSubjectDN();
            if (!((Object)principal).equals(principal2)) continue;
            try {
                if (bl) {
                    x509Certificate.checkValidity();
                }
                x509CertificateArray[n] = x509Certificate;
                ++n;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                WeblogicHandler.debugEaten(certificateExpiredException);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                WeblogicHandler.debugEaten(certificateNotYetValidException);
            }
        }
        if (n != 0) {
            return x509CertificateArray;
        }
        return null;
    }

    public static boolean processCertificatePolicies(X509Certificate x509Certificate, SSLSocket sSLSocket) {
        boolean bl = true;
        CertificatePolicy[] certificatePolicyArray = null;
        try {
            certificatePolicyArray = CertificatePoliciesImpl.getPolicies(x509Certificate);
        }
        catch (CertificateParsingException certificateParsingException) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_ERROR)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_ERROR, "Cannot Get Extension out of the Certificate ", certificateParsingException);
            }
            throw new RuntimeException("Cannot get the Extension from certificate");
        }
        if (certificatePolicyArray == null || certificatePolicyArray.length == 0) {
            return false;
        }
        for (int i = 0; i < certificatePolicyArray.length; ++i) {
            CertificatePolicy certificatePolicy = certificatePolicyArray[i];
            String string = certificatePolicy.getID();
            if ("2.5.29.32.0".equals(string)) {
                return true;
            }
            if (!WeblogicHandler.isPolicyAllowed(string)) {
                SSLSetup.logCertificatePolicyIdDoesntExistIntheList(sSLSocket, string);
                bl = false;
            }
            CertificatePolicyQualifier[] certificatePolicyQualifierArray = certificatePolicy.getPolicyQualifiers();
            for (int j = 0; j < certificatePolicyQualifierArray.length; ++j) {
                CertificatePolicyQualifier certificatePolicyQualifier = certificatePolicyQualifierArray[j];
                if ("1.3.6.1.5.5.7.2.1".equalsIgnoreCase(certificatePolicyQualifier.getID())) continue;
                SSLSetup.logPolicyQualifierIdNotCPS(sSLSocket, certificatePolicyQualifier.getID());
                bl = false;
            }
        }
        return bl;
    }
}

