/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.certicom.locale.Resources;
import com.certicom.tls.interfaceimpl.ProtocolVersions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public final class ProtocolVersion
implements Serializable,
ProtocolVersions {
    private boolean rollBack = true;
    private boolean rollForward = true;
    private String description = null;
    private int major;
    private int minor;
    private int recordMajor;
    private int recordMinor;
    private static final String SSLV2_HELLO = "SSLv2Hello";
    private static final String SSLV3 = "SSLv3";
    private static final String TLSV1 = "TLSv1";
    private static final String SSL3_ONLY_TAG = "SSL3-ONLY";
    private static final String TLS1_ONLY_TAG = "TLS1-ONLY";
    private static final String SSL2_TAG = "SSL2";
    private static final String SSL3_TAG = "SSL3";
    private static final String TLS1_TAG = "TLS1";
    private static final String ANY_TAG = "ANY";
    private static final String SSL3_2HI_TAG = "SSL3/2HI";
    private static final String TLS1_2HI_TAG = "TLS1/2HI";

    public ProtocolVersion(int n, int n2) {
        this.major = n;
        this.minor = n2;
        this.recordMajor = n;
        this.recordMinor = n2;
        this.description = this.setDescription(n, n2);
    }

    public ProtocolVersion(InputStream inputStream, ProtocolVersion protocolVersion) throws IOException {
        this(inputStream);
        this.recordMajor = protocolVersion.getMajor();
        this.recordMinor = protocolVersion.getMinor();
        this.SetRollBack_Forward(this.major, this.minor, this.recordMajor, this.recordMinor);
    }

    public ProtocolVersion() {
        this(TLS1_TAG);
    }

    public ProtocolVersion(String string) {
        this.description = string;
        if (string.equalsIgnoreCase(TLS1_TAG)) {
            this.major = 3;
            this.minor = 1;
            this.recordMajor = 3;
            this.recordMinor = 0;
        } else if (string.equalsIgnoreCase(SSL3_TAG) || string.equalsIgnoreCase(SSL3_2HI_TAG)) {
            this.major = 3;
            this.minor = 0;
            this.recordMajor = 0;
            this.recordMinor = 2;
            this.rollForward = false;
        } else if (string.equalsIgnoreCase(SSL2_TAG)) {
            this.major = 0;
            this.minor = 2;
            this.recordMajor = 0;
            this.recordMinor = 2;
            this.rollForward = false;
        } else if (string.equalsIgnoreCase(ANY_TAG) || string.equalsIgnoreCase(TLS1_2HI_TAG)) {
            this.major = 3;
            this.minor = 1;
            this.recordMajor = 0;
            this.recordMinor = 2;
        } else if (string.equalsIgnoreCase(TLS1_ONLY_TAG)) {
            this.major = 3;
            this.minor = 1;
            this.rollBack = false;
            this.rollForward = false;
            this.recordMajor = 3;
            this.recordMinor = 1;
        } else if (string.equalsIgnoreCase(SSL3_ONLY_TAG)) {
            this.major = 3;
            this.minor = 0;
            this.rollBack = false;
            this.rollForward = false;
            this.recordMajor = 3;
            this.recordMinor = 0;
        } else {
            throw new IllegalArgumentException(Resources.getMessage("133"));
        }
    }

    public ProtocolVersion(InputStream inputStream) throws IOException {
        this.major = inputStream.read();
        this.minor = inputStream.read();
        this.recordMajor = this.major;
        this.recordMinor = this.minor;
        this.description = this.setDescription(this.major, this.minor);
    }

    public boolean isSSL2Hello() {
        return this.recordMajor == 0 && this.recordMinor == 2;
    }

    public boolean isRollBack() {
        return this.rollBack;
    }

    public boolean isRollForward() {
        return this.rollForward;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRecordMajor() {
        return this.recordMajor;
    }

    public int getRecordMinor() {
        return this.recordMinor;
    }

    public void resetRecord() {
        this.recordMajor = this.major;
        this.recordMinor = this.minor;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object object) {
        if (object instanceof ProtocolVersion) {
            ProtocolVersion protocolVersion = (ProtocolVersion)object;
            return protocolVersion.major == this.major && protocolVersion.minor == this.minor;
        }
        if (object instanceof String) {
            return this.equals(new ProtocolVersion((String)object));
        }
        return false;
    }

    public byte[] toByteArray() {
        return new byte[]{(byte)this.major, (byte)this.minor};
    }

    public String toString() {
        return this.getDescription();
    }

    private String setDescription(int n, int n2) {
        if (n == 0 && n2 == 2) {
            return SSL2_TAG;
        }
        if (n == 3 && n2 == 0) {
            return SSL3_TAG;
        }
        if (n == 3 && n2 == 1) {
            return TLS1_TAG;
        }
        throw new IllegalArgumentException(Resources.getMessage("133"));
    }

    private void SetRollBack_Forward(int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4 || n2 - n4 == -1) {
            this.rollBack = false;
            this.rollForward = false;
        } else if (n2 - n4 == -2) {
            this.rollBack = true;
            this.rollForward = false;
        }
    }

    public static String getDescriptionFromProtocols(String[] stringArray) {
        String string = "Protocols not supported: ";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(SSLV2_HELLO)) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals(SSLV3)) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals(TLSV1)) {
                bl4 = true;
                continue;
            }
            bl = true;
            string = string + stringArray[i] + " ";
        }
        if (bl) {
            throw new IllegalArgumentException(string);
        }
        String string2 = null;
        if (bl3 && !bl2 && !bl4) {
            string2 = SSL3_ONLY_TAG;
        } else if (bl4 && !bl2 && !bl3) {
            string2 = TLS1_ONLY_TAG;
        } else if (bl2 && bl3 && !bl4) {
            string2 = SSL3_TAG;
        } else if (bl3 && bl4 && !bl2) {
            string2 = TLS1_TAG;
        } else if (bl2 && bl3 && bl4) {
            string2 = ANY_TAG;
        } else {
            if (bl2 && !bl3 && !bl4) {
                throw new IllegalArgumentException("SSLv2Hello cannot be enabled unless SSLv3 or TLSv1 is also enabled.");
            }
            if (bl2 && bl4 && !bl3) {
                throw new IllegalArgumentException("SSLv2Hello TLSv1 cannot be enabled unless SSLv3 is also enabled.");
            }
        }
        return string2;
    }

    public String[] getEnabledProtocols() {
        String[] stringArray = null;
        if (this.description.equals(SSL3_ONLY_TAG)) {
            stringArray = new String[]{SSLV3};
        } else if (this.description.equals(TLS1_ONLY_TAG)) {
            stringArray = new String[]{TLSV1};
        } else if (this.description.equals(SSL3_TAG) || this.description.equals(SSL3_2HI_TAG)) {
            stringArray = new String[]{SSLV2_HELLO, SSLV3};
        } else if (this.description.equals(TLS1_TAG)) {
            stringArray = new String[]{SSLV3, TLSV1};
        } else if (this.description.equals(ANY_TAG) || this.description.equals(TLS1_2HI_TAG)) {
            stringArray = new String[]{SSLV2_HELLO, SSLV3, TLSV1};
        }
        return stringArray;
    }

    public static String[] getSupportedProtocols() {
        return new String[]{SSLV2_HELLO, SSLV3, TLSV1};
    }
}

