/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.tls.TLSSession;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.interfaceimpl.SessionID;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public final class SessionDBImpl
implements TLSSessionDB {
    private HashMap db = new HashMap();
    private static int sessionTTL;
    private static final int CLEANUP_PERIOD = 500;
    private int opsSinceCleanup;

    public boolean isExpired(TLSSession tLSSession) {
        return sessionTTL > 0 && tLSSession.getLastUsedTime() + (long)sessionTTL < System.currentTimeMillis();
    }

    public synchronized void cleanup() {
        if (sessionTTL > 0 && this.opsSinceCleanup++ > 500) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Cleaning up Session Cache", null);
            }
            if (this.db.size() > 0) {
                Enumeration enumeration = new Vector(this.db.keySet()).elements();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (!this.isExpired((TLSSession)this.db.get(k))) continue;
                    this.db.remove(k);
                }
            }
            this.opsSinceCleanup = 0;
        }
    }

    public synchronized int getSize() {
        return this.db.size();
    }

    public synchronized boolean isEmpty() {
        return this.db.isEmpty();
    }

    public synchronized TLSSession get(Serializable serializable) {
        TLSSession tLSSession = (TLSSession)this.db.get(serializable);
        if (tLSSession != null) {
            if (this.isExpired(tLSSession)) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Session expired and is being removed for key: " + serializable, null);
                }
                this.remove(serializable);
                return null;
            }
            tLSSession.setLastUsedTime(System.currentTimeMillis());
        }
        return tLSSession;
    }

    public synchronized TLSSession get(byte[] byArray) {
        return this.get(new SessionID(byArray));
    }

    public synchronized TLSSession getByPeerID(Serializable serializable) {
        Enumeration enumeration = new Vector(this.db.values()).elements();
        while (enumeration.hasMoreElements()) {
            TLSSession tLSSession = (TLSSession)enumeration.nextElement();
            if (!serializable.equals(tLSSession.getPeerID()) || this.isExpired(tLSSession)) continue;
            tLSSession.setLastUsedTime(System.currentTimeMillis());
            return tLSSession;
        }
        return null;
    }

    public synchronized TLSSession put(Serializable serializable, TLSSession tLSSession) {
        if (tLSSession != null) {
            tLSSession.setLastUsedTime(System.currentTimeMillis());
        }
        this.cleanup();
        TLSSession tLSSession2 = this.db.put(serializable, tLSSession);
        return tLSSession2;
    }

    public synchronized TLSSession put(byte[] byArray, TLSSession tLSSession) {
        return this.put(new SessionID(byArray), tLSSession);
    }

    public synchronized TLSSession remove(Serializable serializable) {
        return (TLSSession)this.db.remove(serializable);
    }

    public synchronized TLSSession remove(byte[] byArray) {
        return this.remove(new SessionID(byArray));
    }

    public synchronized Enumeration getSessions() {
        return new Vector(this.db.values()).elements();
    }

    public synchronized Enumeration getKeys() {
        return new Vector(this.db.keySet()).elements();
    }

    public synchronized void clear() {
        this.db.clear();
    }

    static {
        block4: {
            sessionTTL = 90000;
            try {
                String string = System.getProperty("weblogic.security.SSL.sessionCache.ttl");
                if (string != null) {
                    sessionTTL = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                if (!WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_WARN)) break block4;
                WeblogicHandler.debug(WeblogicHandler.DEBUG_WARN, "Failed to read property: weblogic.security.SSL.sessionCache.ttl", exception);
            }
        }
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "SSL Session TTL :" + sessionTTL, null);
        }
    }
}

