/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.tls.record.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class SessionID
implements Serializable {
    private static final byte[] ZERO_LENGTH = new byte[]{0};
    private byte[] id;

    public SessionID() {
        this.id = new byte[0];
    }

    public SessionID(SecureRandom secureRandom) {
        this.id = new byte[16];
        secureRandom.nextBytes(this.id);
    }

    public SessionID(byte[] byArray) {
        this.setID(byArray);
    }

    public SessionID(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n > 32 || n < 0) {
            throw new IOException();
        }
        this.id = new byte[n];
        Util.readFully(this.id, inputStream);
    }

    public SessionID(InputStream inputStream, int n) throws IOException {
        if (n != 0 && n != 16) {
            throw new IOException();
        }
        this.id = new byte[n];
        Util.readFully(this.id, inputStream);
    }

    public byte[] getID() {
        return this.id;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(33);
        try {
            if (this.id.length == 0) {
                byteArrayOutputStream.write(ZERO_LENGTH);
            } else {
                byteArrayOutputStream.write(this.id.length);
                byteArrayOutputStream.write(this.id);
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setID(byte[] byArray) {
        if (byArray == null || byArray.length > 32) {
            throw new IllegalArgumentException(Resources.getMessage("173"));
        }
        this.id = byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionID)) {
            return false;
        }
        SessionID sessionID = (SessionID)object;
        if (this.id.length != sessionID.id.length) {
            return false;
        }
        for (int i = 0; i < this.id.length; ++i) {
            if (this.id[i] == sessionID.id[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.id.length;
        if (n < 2) {
            return 0;
        }
        int n2 = this.id[n - 2] << 1 & this.id[n - 1];
        return n2;
    }

    public boolean isEmpty() {
        return this.id.length == 0;
    }
}

