/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.bea.sslplus.TwoWaySSLHandshakeStageSocketException;
import com.bea.sslplus.WeblogicHandler;
import com.certicom.io.InputSSLIO;
import com.certicom.io.InputSSLIOStream;
import com.certicom.io.InputSSLIOStreamWrapper;
import com.certicom.io.OutputSSLIO;
import com.certicom.io.OutputSSLIOStream;
import com.certicom.io.OutputSSLIOStreamWrapper;
import com.certicom.locale.Resources;
import com.certicom.security.cert.internal.x509.ServerGatedCryptoCert;
import com.certicom.tls.TLSConnection;
import com.certicom.tls.TLSSession;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.ciphersuite.CryptoNames;
import com.certicom.tls.ciphersuite.SecurityParameters;
import com.certicom.tls.event.HandshakeWouldBlockException;
import com.certicom.tls.event.TLSHandshakeCompletedEvent;
import com.certicom.tls.event.TLSHandshakeCompletedListener;
import com.certicom.tls.interfaceimpl.AlertEvent;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionID;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.interfaceimpl.TLSSystem;
import com.certicom.tls.record.ReadHandler;
import com.certicom.tls.record.WriteHandler;
import com.certicom.tls.record.alert.Alert;
import com.certicom.tls.record.alert.AlertHandler;
import com.certicom.tls.record.handshake.HandshakeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import weblogic.security.utils.SSLIOContext;

public final class TLSConnectionImpl
implements TLSConnection,
CryptoNames {
    private Object certificateCallbackRef;
    private HandshakeHandler handshakeHandler;
    private TLSSessionImpl session;
    private WriteHandler writeHandler;
    private ReadHandler readHandler;
    private AlertHandler alertHandler;
    private ProtocolVersion protocolVersion;
    private TLSSessionDB sessionDB;
    private Serializable peerID;
    private CertificateSupport certificateSupport;
    private Vector enabledCipherSuites;
    private Vector authenticatedCipherSuites;
    private Vector handshakeCompletedListeners = new Vector();
    private boolean handshakeComplete = false;
    private boolean handshakeStarted = false;
    private boolean client;
    private boolean needClientAuth = false;
    private boolean closed = false;
    private boolean enableSessionCreation = true;
    private boolean waitForCloseNotify = true;
    private boolean exportLimited = false;
    private boolean srvGatedCryptoOn = false;
    private boolean closeNotifyReceived = false;
    private boolean debugFlag = false;
    private OutputSSLIO systemOut = null;
    private SSLIOContext sslIOCtx = null;
    private boolean versionChecked = false;

    public String getFailureDetails() {
        return (String)this.session.getValue("weblogic.security.ssl.failureDetails");
    }

    public void setFailureDetails(String string) {
        this.session.putValue("weblogic.security.ssl.failureDetails", string);
    }

    public boolean notCompleteSSLRecord() {
        return this.sslIOCtx != null && this.sslIOCtx.isMuxerActivated() && !this.sslIOCtx.hasSSLRecord();
    }

    public InputStream getMuxerInputStream() {
        return this.sslIOCtx == null ? null : this.sslIOCtx.getMuxerIS();
    }

    public SSLSocket getSSLSocket() {
        return this.sslIOCtx == null ? null : this.sslIOCtx.getSSLSocket();
    }

    public void setVersionCheck(boolean bl) {
        this.versionChecked = bl;
    }

    public boolean getVersionCheck() {
        return this.versionChecked;
    }

    public TLSConnectionImpl(SSLSocket sSLSocket, InputStream inputStream, OutputStream outputStream, Serializable serializable, TLSSessionDB tLSSessionDB, ProtocolVersion protocolVersion, Vector vector, Vector vector2, CertificateSupport certificateSupport, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this(new InputSSLIOStream(inputStream), new OutputSSLIOStream(outputStream), serializable, tLSSessionDB, protocolVersion, vector, vector2, certificateSupport, bl, bl2, bl3);
        this.sslIOCtx = WeblogicHandler.addSSLIOContext(inputStream, outputStream, sSLSocket);
    }

    public TLSConnectionImpl(SSLSocket sSLSocket, InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable, TLSSessionDB tLSSessionDB, ProtocolVersion protocolVersion, Vector vector, Vector vector2, CertificateSupport certificateSupport, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this(inputSSLIO, outputSSLIO, serializable, tLSSessionDB, protocolVersion, vector, vector2, certificateSupport, bl, bl2, bl3);
        this.sslIOCtx = WeblogicHandler.addSSLIOContext(inputSSLIO, outputSSLIO, sSLSocket);
    }

    public TLSConnectionImpl(InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable, TLSSessionDB tLSSessionDB, ProtocolVersion protocolVersion, Vector vector, Vector vector2, CertificateSupport certificateSupport, boolean bl, boolean bl2, boolean bl3) {
        this.protocolVersion = protocolVersion;
        this.sessionDB = tLSSessionDB;
        this.enabledCipherSuites = vector;
        this.authenticatedCipherSuites = vector2;
        this.certificateSupport = certificateSupport;
        this.peerID = serializable;
        this.client = bl;
        this.exportLimited = bl2;
        this.srvGatedCryptoOn = bl3;
        this.systemOut = outputSSLIO;
        this.alertHandler = new AlertHandler(this);
        this.handshakeHandler = new HandshakeHandler(this, certificateSupport);
        this.writeHandler = new WriteHandler(this, outputSSLIO);
        this.readHandler = new ReadHandler(this, inputSSLIO);
        this.setClient(bl);
        this.setWaitForCloseNotify(Boolean.getBoolean("weblogic.security.SSL.waitForCloseNotify"));
    }

    public boolean getServerGatedCrypto() {
        return this.srvGatedCryptoOn;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean bl) {
        this.client = bl;
        if (bl) {
            this.session = (TLSSessionImpl)this.sessionDB.get(this.peerID);
            if (this.session == null) {
                this.session = new TLSSessionImpl(this.peerID, this.sessionDB, new SessionID());
            }
        } else {
            this.session = new TLSSessionImpl(this.peerID, this.sessionDB, new SessionID(TLSSystem.getRandomNumberGenerator()));
        }
        this.handshakeHandler.resetState();
    }

    public HandshakeHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public TLSSessionDB getSessionDB() {
        return this.sessionDB;
    }

    public boolean getEnableSessionCreation() {
        return this.session.getCacheOn();
    }

    public CertificateSupport getCertificateSupport() {
        return this.certificateSupport;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.session.setCacheOn(bl);
    }

    public boolean isWaitForCloseNotify() {
        return this.waitForCloseNotify;
    }

    public void setWaitForCloseNotify(boolean bl) {
        this.waitForCloseNotify = bl;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setSessionImpl(TLSSessionImpl tLSSessionImpl) {
        this.session = tLSSessionImpl;
    }

    public TLSSession getSession() {
        return this.session;
    }

    public TLSSessionImpl getSessionImpl() {
        return this.session;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler;
    }

    public void setEnabledCipherSuites(String[] stringArray) throws IllegalArgumentException {
        int n;
        Vector<CipherSuite> vector = new Vector<CipherSuite>();
        for (n = 0; n < stringArray.length; ++n) {
            try {
                CipherSuite cipherSuite = CipherSuiteSupport.getCipherSuite(stringArray[n]);
                if (this.exportLimited && !cipherSuite.isExportable()) {
                    throw new IllegalArgumentException(Resources.getMessage("45") + stringArray[n]);
                }
                vector.addElement(cipherSuite);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                throw new IllegalArgumentException(stringArray[n] + " " + Resources.getMessage("134"));
            }
        }
        this.enabledCipherSuites.removeAllElements();
        for (n = 0; n < vector.size(); ++n) {
            this.enabledCipherSuites.addElement(vector.elementAt(n));
        }
        this.resetAuthenticatedCipherSuiteSupport();
    }

    private void resetAuthenticatedCipherSuiteSupport() {
        this.authenticatedCipherSuites.removeAllElements();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        X509Certificate[] x509CertificateArray = this.certificateSupport.getAuthChain("RSA", 0);
        if (x509CertificateArray != null) {
            bl = true;
        }
        if (this.certificateSupport.getAuthChain("SHA1withDSA", 0) != null) {
            bl2 = true;
        }
        if (this.certificateSupport.getAuthChain("ECDSA", 0) != null) {
            bl3 = true;
        }
        if (this.certificateSupport.getAuthChain("HYBRID", 0) != null) {
            bl5 = true;
        }
        if (bl && this.srvGatedCryptoOn) {
            ServerGatedCryptoCert serverGatedCryptoCert = new ServerGatedCryptoCert(x509CertificateArray);
            bl4 = serverGatedCryptoCert.getSGCCertificateType() != 0;
        }
        for (int i = 0; i < this.enabledCipherSuites.size(); ++i) {
            int n;
            CipherSuite cipherSuite = (CipherSuite)this.enabledCipherSuites.elementAt(i);
            int n2 = cipherSuite.getKeyAgreementAlgorithm();
            if (n2 == 2 && bl2) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 10 && bl) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 4 && bl2) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 3 && bl2) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 11 && bl) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 5 && bl3) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 12 && bl5) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 1 || n2 == 9) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 6 && bl) {
                if (!cipherSuite.isExportable() && this.exportLimited && !bl4) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 7 && bl) {
                n = ((RSAPublicKey)this.certificateSupport.getAuthChain("RSA", 0)[0].getPublicKey()).getModulus().bitLength();
                if (n > 512 && this.certificateSupport.getRSAExportKey(512) == null || !cipherSuite.isExportable() && this.exportLimited && !bl4) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 != 8 || !bl || (n = ((RSAPublicKey)this.certificateSupport.getAuthChain("RSA", 0)[0].getPublicKey()).getModulus().bitLength()) > 1024 && this.certificateSupport.getRSAExportKey(1024) == null || !cipherSuite.isExportable() && this.exportLimited && !bl4) continue;
            this.authenticatedCipherSuites.addElement(cipherSuite);
        }
    }

    public String[] getEnabledCipherSuites() {
        Vector vector = null;
        vector = !this.client || this.needClientAuth ? this.authenticatedCipherSuites : this.enabledCipherSuites;
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((CipherSuite)enumeration.nextElement()).getDescription();
            ++n;
        }
        return stringArray;
    }

    public Vector getEnabledCipherSuitesVector() {
        if (!this.client || this.needClientAuth) {
            return this.authenticatedCipherSuites;
        }
        return this.enabledCipherSuites;
    }

    public void startHandshake() throws IOException {
        this.handshakeStarted = true;
        try {
            this.handshakeHandler.startHandshake();
        }
        catch (HandshakeWouldBlockException handshakeWouldBlockException) {
            WeblogicHandler.debugEaten(handshakeWouldBlockException);
        }
    }

    public synchronized void completeHandshake() throws IOException {
        if (!this.handshakeStarted) {
            this.startHandshake();
        }
        try {
            this.readHandler.readUntilHandshakeComplete();
        }
        catch (HandshakeWouldBlockException handshakeWouldBlockException) {
            WeblogicHandler.debugEaten(handshakeWouldBlockException);
        }
        catch (SocketException socketException) {
            if (this.isClient() && this.handshakeHandler.isClientCertSentState()) {
                TwoWaySSLHandshakeStageSocketException twoWaySSLHandshakeStageSocketException = new TwoWaySSLHandshakeStageSocketException("SocketException during 2 way handshake; check client certificate or the network connection", socketException);
                throw twoWaySSLHandshakeStageSocketException;
            }
            throw socketException;
        }
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isCloseNotifyReceived() {
        return this.closeNotifyReceived;
    }

    public void setHandshakeComplete(boolean bl) {
        this.handshakeComplete = bl;
        if (bl) {
            TLSHandshakeCompletedEvent tLSHandshakeCompletedEvent = new TLSHandshakeCompletedEvent(this);
            for (int i = 0; i < this.handshakeCompletedListeners.size(); ++i) {
                ((TLSHandshakeCompletedListener)this.handshakeCompletedListeners.elementAt(i)).handshakeCompleted(tLSHandshakeCompletedEvent);
            }
        }
    }

    public void setCertificateCallbackRef(Object object) {
        this.certificateCallbackRef = object;
    }

    public Object getCertificateCallbackRef() {
        return this.certificateCallbackRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (!this.closed) {
                this.closeWriteHandler();
            }
            if (this.protocolVersion.equals(ProtocolVersion.SSL20)) {
                this.closeReadHandler();
            } else if (!this.waitForCloseNotify) {
                this.closeReadHandler();
            }
        }
        catch (HandshakeWouldBlockException handshakeWouldBlockException) {
            WeblogicHandler.debugEaten(handshakeWouldBlockException);
        }
        finally {
            if (this.sslIOCtx != null) {
                WeblogicHandler.removeSSLIOContext(this.sslIOCtx);
            }
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public OutputStream getOutputStream() {
        return new OutputSSLIOStreamWrapper(this.writeHandler);
    }

    public InputStream getInputStream() {
        return new InputSSLIOStreamWrapper(this.readHandler);
    }

    public OutputSSLIO getOutputSSLIO() {
        return this.writeHandler;
    }

    public InputSSLIO getInputSSLIO() {
        return this.readHandler;
    }

    public void closeWriteHandler() throws IOException, HandshakeWouldBlockException {
        block9: {
            if (!this.writeHandler.isOpen()) {
                return;
            }
            boolean bl = false;
            Alert alert = new Alert(1, 0);
            if (!this.protocolVersion.equals(ProtocolVersion.SSL20)) {
                try {
                    this.writeHandler.write(alert);
                    this.writeHandler.flushOutput();
                }
                catch (IOException iOException) {
                    if (!this.closeNotifyReceived) {
                        throw iOException;
                    }
                }
                catch (HandshakeWouldBlockException handshakeWouldBlockException) {
                    if (this.closeNotifyReceived) break block9;
                    throw handshakeWouldBlockException;
                }
            }
        }
        this.writeHandler.close();
        if (!this.protocolVersion.equals(ProtocolVersion.SSL20) && this.waitForCloseNotify && !this.closeNotifyReceived) {
            this.readHandler.read();
        }
    }

    public void closeReadHandler() {
        this.readHandler.close();
    }

    public void drop() {
        try {
            this.writeHandler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.readHandler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.invalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    public AlertEvent fireAlertSent(Alert alert) throws IOException, HandshakeWouldBlockException {
        this.writeHandler.write(alert);
        this.writeHandler.flushOutput();
        AlertEvent alertEvent = new AlertEvent(this, alert.getSeverity() == 2, alert.getAlertType());
        if (!alertEvent.isIgnored()) {
            this.drop();
            this.fireException(alertEvent);
        }
        return alertEvent;
    }

    public AlertEvent fireAlertReceived(Alert alert) throws IOException {
        AlertEvent alertEvent = new AlertEvent(this, alert.getSeverity() == 2, alert.getAlertType());
        if (alertEvent.isFatal()) {
            this.drop();
            this.fireException(alertEvent);
        }
        if (alertEvent.getType() == 0) {
            this.closeNotifyReceived = true;
        }
        return alertEvent;
    }

    public void addHandshakeCompletedListener(TLSHandshakeCompletedListener tLSHandshakeCompletedListener) {
        this.handshakeCompletedListeners.addElement(tLSHandshakeCompletedListener);
    }

    public void removeHandshakeCompletedListener(TLSHandshakeCompletedListener tLSHandshakeCompletedListener) {
        this.handshakeCompletedListeners.removeElement(tLSHandshakeCompletedListener);
    }

    public void setDebugFlag() {
        this.debugFlag = true;
        this.handshakeHandler.setDebugFlag();
    }

    public boolean returnDebugFlag() {
        return this.debugFlag;
    }

    public void setHandshakeRollBackBug(boolean bl) {
        this.getHandshakeHandler().setHandshakeRollBackBug(bl);
    }

    public boolean getHandshakeRollBackBug() {
        return this.getHandshakeHandler().getHandshakeRollBackBug();
    }

    public void fireException(AlertEvent alertEvent) throws IOException {
        String string = this.getFailureDetails();
        if (string == null) {
            string = alertEvent.toString();
        }
        switch (alertEvent.getType()) {
            case 0: 
            case 90: {
                throw new SSLException(string);
            }
            case 10: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 50: 
            case 51: 
            case 80: {
                throw new SSLProtocolException(string);
            }
            case 40: 
            case 47: 
            case 49: 
            case 60: 
            case 70: 
            case 71: 
            case 100: {
                throw new SSLHandshakeException(string);
            }
            case 41: {
                throw new SSLPeerUnverifiedException(alertEvent.toString());
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                throw new SSLKeyException(string);
            }
        }
        throw new SSLProtocolException(string);
    }

    public byte[] getMasterSecret() {
        return this.handshakeHandler.getMasterSecret();
    }

    public byte[] getClientRandom() {
        return this.handshakeHandler.getClientRandom();
    }

    public byte[] getServerRandom() {
        return this.handshakeHandler.getServerRandom();
    }

    public byte[] PRF(byte[] byArray, int n) throws NoSuchAlgorithmException {
        return SecurityParameters.TLS_PRF(this.getMasterSecret(), byArray, this.getClientRandom(), this.getServerRandom(), n);
    }

    public void sendAlert(int n, int n2) throws IOException {
        if (this.protocolVersion.getMajor() < 3) {
            throw new IOException(Resources.getMessage("133"));
        }
        if (n != 1 && n != 2) {
            throw new IOException(Resources.getMessage("255"));
        }
        switch (n2) {
            case 0: 
            case 10: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 60: 
            case 70: 
            case 71: 
            case 80: 
            case 90: 
            case 100: {
                break;
            }
            default: {
                throw new IOException(Resources.getMessage("254"));
            }
        }
        if (!this.protocolVersion.getDescription().equals("TLS1")) {
            switch (n2) {
                case 21: 
                case 22: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 60: 
                case 70: 
                case 71: 
                case 80: 
                case 90: 
                case 100: {
                    throw new IOException(Resources.getMessage("254"));
                }
            }
        } else {
            switch (n2) {
                case 41: {
                    throw new IOException(Resources.getMessage("254"));
                }
            }
        }
        Alert alert = new Alert(n, n2);
        try {
            this.getWriteHandler().fireAlert(alert);
        }
        catch (HandshakeWouldBlockException handshakeWouldBlockException) {
            WeblogicHandler.debugEaten(handshakeWouldBlockException);
        }
    }

    public void setWriteFragmentLength(int n) {
        this.getWriteHandler().getMessageEncryptor().setWriteFragmentLength(n);
    }

    public boolean isFinishedSent() {
        return this.handshakeHandler.getLastMessageType() == 20;
    }

    public boolean hasPendingBytes() {
        return this.systemOut.hasPendingBytes();
    }

    public void flushNetworkData() throws IOException {
        this.systemOut.flush();
    }

    public void setEnabledProtocols(String[] stringArray) {
        ProtocolVersion protocolVersion;
        if (null == stringArray || stringArray.length < 1) {
            throw new IllegalArgumentException(this.getClass().getName() + "No protocols passed in.");
        }
        if (this.handshakeStarted && !this.isHandshakeComplete()) {
            throw new IllegalArgumentException(this.getClass().getName() + "Attempt to change protocol during handshake.");
        }
        this.protocolVersion = protocolVersion = new ProtocolVersion(ProtocolVersion.getDescriptionFromProtocols(stringArray));
        this.handshakeHandler.setHelloProtocol(protocolVersion);
    }

    public String[] getEnabledProtocols() {
        return this.getProtocolVersion().getEnabledProtocols();
    }

    public String[] getSupportedProtocols() {
        this.getProtocolVersion();
        return ProtocolVersion.getSupportedProtocols();
    }
}

