/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.certicom.tls.TLSSession;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionID;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;

public final class TLSSessionImpl
implements TLSSession {
    private SessionID sessionID = new SessionID();
    private Serializable peerID;
    private TLSSessionDB sessionDB;
    private X509Certificate[] peerCertChain = null;
    private Date creationTime = new Date();
    private Date lastConnectionCreationTime = new Date();
    private Vector appTags = new Vector();
    private Vector appValues = new Vector();
    private boolean cacheOn = true;
    private boolean client = true;
    private byte[] masterSecret;
    private CipherSuite cipherSuite;
    private ProtocolVersion protocolVersion;
    private long lastUsedTime;

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(long l) {
        this.lastUsedTime = l;
    }

    public TLSSessionImpl(Serializable serializable, TLSSessionDB tLSSessionDB, SessionID sessionID) {
        this.peerID = serializable;
        this.sessionDB = tLSSessionDB;
        this.sessionID = sessionID;
    }

    public void putValue(String string, Object object) {
        this.appTags.addElement(string);
        this.appValues.addElement(object);
    }

    public Object removeValue(String string) {
        int n = this.appTags.indexOf(string);
        Object e = this.appValues.elementAt(n);
        if (n != -1) {
            this.appTags.removeElementAt(n);
            this.appValues.removeElementAt(n);
        }
        return e;
    }

    public String[] getValueNames() {
        Object[] objectArray = new String[this.appTags.size()];
        this.appTags.copyInto(objectArray);
        return objectArray;
    }

    public Object getValue(String string) {
        int n = this.appTags.indexOf(string);
        if (n != -1) {
            return this.appValues.elementAt(n);
        }
        return null;
    }

    public void setCacheOn(boolean bl) {
        this.cacheOn = bl;
    }

    public boolean getCacheOn() {
        return this.cacheOn;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Certificate[] getPeerCertificates() {
        return this.peerCertChain;
    }

    public void setPeerCertChain(X509Certificate[] x509CertificateArray) {
        this.peerCertChain = x509CertificateArray;
    }

    public TLSSessionDB getSessionDB() {
        return this.sessionDB;
    }

    public void invalidate() {
        this.sessionDB.remove(this.peerID);
        this.sessionDB.remove(this.sessionID);
    }

    public boolean isResumable() {
        return this.sessionDB.get(this.peerID) != null || this.sessionDB.get(this.sessionID) != null;
    }

    public void makeResumable(boolean bl) {
        if (!this.cacheOn) {
            return;
        }
        if (bl) {
            this.sessionDB.put(this.peerID, (TLSSession)this);
        } else {
            this.sessionDB.put(this.sessionID, (TLSSession)this);
        }
    }

    public String getCipherSuite() {
        return this.cipherSuite.getDescription();
    }

    public CipherSuite getCipher() {
        return this.cipherSuite;
    }

    public void setCipher(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public Date getLastConnectionCreationTime() {
        return this.lastConnectionCreationTime;
    }

    public byte[] getID() {
        return this.sessionID.getID();
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    public Serializable getPeerID() {
        return this.peerID;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(byte[] byArray) {
        this.masterSecret = byArray;
    }

    public String getProtocol() {
        return this.protocolVersion.toString();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

