/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.tls.interfaceimpl;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.io.InputSSLIO;
import com.certicom.io.OutputSSLIO;
import com.certicom.locale.Resources;
import com.certicom.security.asn1.ASN1Type;
import com.certicom.security.cert.internal.x509.ServerGatedCryptoCert;
import com.certicom.tls.TLSConnection;
import com.certicom.tls.TLSSessionDB;
import com.certicom.tls.ciphersuite.CipherSuite;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.ProtocolVersion;
import com.certicom.tls.interfaceimpl.SessionDBImpl;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;

public final class TLSSystem
implements Serializable,
Cloneable {
    private static boolean certBasicConstBug = false;
    private static boolean HandshakeRollBackBug = false;
    private static boolean acceptEmptyCertRequest = false;
    private static boolean sendEmptyCertRequest = false;
    private static int maxHandshakeMessageSize = 65535;
    private static SecureRandom randomNumberGenerator;
    private TLSSessionDB sessionDB = new SessionDBImpl();
    private Vector enabledCipherSuites = new Vector();
    private Vector authenticatedCipherSuites = new Vector();
    private CertificateSupport certificateSupport;
    private ProtocolVersion helloProtocol;
    private boolean exportLimited = false;
    private boolean strongLimited = false;
    private boolean debugFlag = false;
    private boolean srvGatedCryptoOn = false;
    private int WRITE_BLOCK_SIZE = 16384;
    private static boolean x509StrictConstraints;
    private static boolean x509NoV1CAs;

    public static synchronized void setX509StrictConstraints(boolean bl) {
        x509StrictConstraints = bl;
    }

    public static synchronized boolean getX509StrictConstraints() {
        return x509StrictConstraints;
    }

    public static synchronized void setX509NoV1CAs(boolean bl) {
        x509NoV1CAs = bl;
    }

    public static synchronized boolean getX509NoV1CAs() {
        return x509NoV1CAs;
    }

    public TLSSystem() {
        this(new CertificateSupport());
    }

    public TLSSystem(CertificateSupport certificateSupport) {
        this.setCertificateSupport(certificateSupport);
        this.sessionDB = new SessionDBImpl();
        this.helloProtocol = ProtocolVersion.TLS10_WITH_SSL20_HELLO;
        if (!Kernel.isApplet()) {
            Properties properties;
            if (System.getProperty("UsePointCompression") == null) {
                properties = System.getProperties();
                properties.put("UserPointCompression", "no");
                System.setProperties(properties);
            }
            if (System.getProperty("GuessPointCompression") == null) {
                properties = System.getProperties();
                properties.put("GuessPointCompression", "yes");
                System.setProperties(properties);
            }
        }
    }

    public void setCertificateSupport(CertificateSupport certificateSupport) {
        this.certificateSupport = certificateSupport;
        this.resetCipherSuiteSupport();
    }

    public CertificateSupport getCertificateSupport() {
        return this.certificateSupport;
    }

    public void resetCipherSuiteSupport() {
        CipherSuite[] cipherSuiteArray = CipherSuiteSupport.getCipherSuites();
        this.enabledCipherSuites.removeAllElements();
        for (int i = 0; i < cipherSuiteArray.length; ++i) {
            if (this.strongLimited && (cipherSuiteArray[i].getCertificateType().equalsIgnoreCase("Anonymous") || cipherSuiteArray[i].getDescription().indexOf("NULL") != -1) || this.exportLimited && !cipherSuiteArray[i].isExportable()) continue;
            this.enabledCipherSuites.addElement(cipherSuiteArray[i]);
        }
        if (this.enabledCipherSuites.size() == 0) {
            throw new IllegalStateException(Resources.getMessage("82"));
        }
        this.resetAuthenticatedCipherSuiteSupport();
    }

    public boolean getIsExportedLimited() {
        return this.exportLimited;
    }

    public boolean getIsStrongCipherSuiteLimited() {
        return this.strongLimited;
    }

    public boolean getServerGatedCryptoEnabled() {
        return this.srvGatedCryptoOn;
    }

    public void setIsExportedLimited(boolean bl) {
        this.exportLimited = bl;
        this.resetCipherSuiteSupport();
    }

    public void setIsStrongCipherSuiteLimited(boolean bl) {
        this.strongLimited = bl;
        this.resetCipherSuiteSupport();
    }

    public void setServerGatedCryptoEnabled(boolean bl) {
        this.srvGatedCryptoOn = bl;
    }

    private void resetAuthenticatedCipherSuiteSupport() {
        this.authenticatedCipherSuites.removeAllElements();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        X509Certificate[] x509CertificateArray = this.certificateSupport.getAuthChain("RSA", 0);
        if (x509CertificateArray != null) {
            bl = true;
        }
        if (this.certificateSupport.getAuthChain("SHA1withDSA", 0) != null) {
            bl2 = true;
        }
        if (this.certificateSupport.getAuthChain("ECDSA", 0) != null) {
            bl3 = true;
        }
        if (this.certificateSupport.getAuthChain("HYBRID", 0) != null) {
            bl5 = true;
        }
        if (bl && this.srvGatedCryptoOn) {
            ServerGatedCryptoCert serverGatedCryptoCert = new ServerGatedCryptoCert(x509CertificateArray);
            bl4 = serverGatedCryptoCert.getSGCCertificateType() != 0;
        }
        for (int i = 0; i < this.enabledCipherSuites.size(); ++i) {
            int n;
            CipherSuite cipherSuite = (CipherSuite)this.enabledCipherSuites.elementAt(i);
            int n2 = cipherSuite.getKeyAgreementAlgorithm();
            if (n2 == 2 && bl2) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 10 && bl) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 4 && bl2) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 3 && bl2) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 11 && bl) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 5 && bl3) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 12 && bl5) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 1 || n2 == 9) {
                if (!cipherSuite.isExportable() && this.exportLimited) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 6 && bl) {
                if (!cipherSuite.isExportable() && this.exportLimited && !bl4) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 == 7 && bl) {
                n = ((RSAPublicKey)this.certificateSupport.getAuthChain("RSA", 0)[0].getPublicKey()).getModulus().bitLength();
                if (n > 512 && this.certificateSupport.getRSAExportKey(512) == null || !cipherSuite.isExportable() && this.exportLimited && !bl4) continue;
                this.authenticatedCipherSuites.addElement(cipherSuite);
                continue;
            }
            if (n2 != 8 || !bl || (n = ((RSAPublicKey)this.certificateSupport.getAuthChain("RSA", 0)[0].getPublicKey()).getModulus().bitLength()) > 1024 && this.certificateSupport.getRSAExportKey(1024) == null || !cipherSuite.isExportable() && this.exportLimited && !bl4) continue;
            this.authenticatedCipherSuites.addElement(cipherSuite);
        }
    }

    public String[] getEnabledCipherSuites() {
        Enumeration enumeration = this.enabledCipherSuites.elements();
        String[] stringArray = new String[this.enabledCipherSuites.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((CipherSuite)enumeration.nextElement()).getDescription();
            ++n;
        }
        return stringArray;
    }

    public String[] getAuthenticatedEnabledCipherSuites() {
        Enumeration enumeration = this.authenticatedCipherSuites.elements();
        String[] stringArray = new String[this.authenticatedCipherSuites.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((CipherSuite)enumeration.nextElement()).getDescription();
            ++n;
        }
        return stringArray;
    }

    public static String[] getSupportedCipherSuites() {
        return CipherSuiteSupport.getCipherSuiteNames();
    }

    public String[] setEnabledCipherSuites(String[] stringArray) throws IllegalArgumentException {
        int n;
        Vector<CipherSuite> vector = new Vector<CipherSuite>();
        for (n = 0; n < stringArray.length; ++n) {
            try {
                CipherSuite cipherSuite = CipherSuiteSupport.getCipherSuite(stringArray[n]);
                if (this.exportLimited && !cipherSuite.isExportable()) {
                    throw new IllegalArgumentException(Resources.getMessage("45") + stringArray[n]);
                }
                vector.addElement(cipherSuite);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                WeblogicHandler.debugEaten(noSuchAlgorithmException);
                throw new IllegalArgumentException(stringArray[n] + " " + Resources.getMessage("134"));
            }
        }
        this.enabledCipherSuites.removeAllElements();
        for (n = 0; n < vector.size(); ++n) {
            this.enabledCipherSuites.addElement(vector.elementAt(n));
        }
        this.resetAuthenticatedCipherSuiteSupport();
        return this.getEnabledCipherSuites();
    }

    public String[] enableCipherSuite(String string) {
        try {
            this.disableCipherSuite(string);
            CipherSuite cipherSuite = CipherSuiteSupport.getCipherSuite(string);
            this.enabledCipherSuites.insertElementAt(cipherSuite, 0);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
        }
        this.resetAuthenticatedCipherSuiteSupport();
        return this.getEnabledCipherSuites();
    }

    public String[] disableCipherSuite(String string) {
        Object[] objectArray;
        boolean bl = true;
        try {
            objectArray = CipherSuiteSupport.getCipherSuite(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            WeblogicHandler.debugEaten(noSuchAlgorithmException);
            bl = false;
        }
        if (this.enabledCipherSuites.size() == 1) {
            bl = false;
        }
        if (bl) {
            objectArray = new CipherSuite[this.enabledCipherSuites.size()];
            this.enabledCipherSuites.copyInto(objectArray);
            for (int i = 0; i < this.enabledCipherSuites.size(); ++i) {
                Object object = objectArray[i];
                if (!((CipherSuite)object).equals(string)) continue;
                this.enabledCipherSuites.removeElement(object);
            }
        }
        this.resetAuthenticatedCipherSuiteSupport();
        return this.getEnabledCipherSuites();
    }

    public static synchronized SecureRandom getRandomNumberGenerator() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new SecureRandom();
            SecureRandom secureRandom = null;
            try {
                secureRandom = JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)"Java");
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using PRNG algorithm: FIPS186Random", null);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed to instantiate FIPS186Random SecureRandom, trying SHA1Random", null);
                }
                try {
                    secureRandom = JSAFE_SecureRandom.getInstance((String)"SHA1Random", (String)"Java");
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Using PRNG algorithm: SHA1Random", null);
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failed to instantiate SHA1Random SecureRandom.", null);
                    }
                    throw new RuntimeException("Failed to instantiate a SecureRandom provider: " + noSuchAlgorithmException2.getMessage());
                }
            }
            secureRandom.setSeed(randomNumberGenerator.generateSeed(64));
            randomNumberGenerator = secureRandom;
        }
        return randomNumberGenerator;
    }

    public static synchronized void setRandomNumberGenerator(SecureRandom secureRandom) {
        randomNumberGenerator = secureRandom;
    }

    public synchronized TLSSessionDB getSessionDB() {
        return this.sessionDB;
    }

    public synchronized void setSessionDB(TLSSessionDB tLSSessionDB) {
        this.sessionDB = tLSSessionDB;
    }

    public String getHelloProtocol() {
        return this.helloProtocol.toString();
    }

    public void setHelloProtocol(String string) throws IllegalArgumentException {
        this.helloProtocol = new ProtocolVersion(string);
    }

    public TLSConnection createClient(SSLSocket sSLSocket, InputStream inputStream, OutputStream outputStream, Serializable serializable) throws IOException {
        Vector vector = (Vector)this.enabledCipherSuites.clone();
        Vector vector2 = (Vector)this.authenticatedCipherSuites.clone();
        TLSConnectionImpl tLSConnectionImpl = new TLSConnectionImpl(sSLSocket, inputStream, outputStream, serializable, this.sessionDB, new ProtocolVersion(this.getHelloProtocol()), vector, vector2, this.certificateSupport, true, this.exportLimited, this.srvGatedCryptoOn);
        if (this.debugFlag) {
            tLSConnectionImpl.setDebugFlag();
        }
        tLSConnectionImpl.setWriteFragmentLength(this.WRITE_BLOCK_SIZE);
        if (HandshakeRollBackBug) {
            tLSConnectionImpl.setHandshakeRollBackBug(HandshakeRollBackBug);
        }
        return tLSConnectionImpl;
    }

    public TLSConnection createServer(SSLSocket sSLSocket, InputStream inputStream, OutputStream outputStream, Serializable serializable) throws IOException {
        Vector vector = (Vector)this.enabledCipherSuites.clone();
        Vector vector2 = (Vector)this.authenticatedCipherSuites.clone();
        TLSConnectionImpl tLSConnectionImpl = new TLSConnectionImpl(sSLSocket, inputStream, outputStream, serializable, this.sessionDB, new ProtocolVersion(this.getHelloProtocol()), vector, vector2, this.certificateSupport, false, this.exportLimited, this.srvGatedCryptoOn);
        if (this.debugFlag) {
            tLSConnectionImpl.setDebugFlag();
        }
        tLSConnectionImpl.setWriteFragmentLength(this.WRITE_BLOCK_SIZE);
        if (HandshakeRollBackBug) {
            tLSConnectionImpl.setHandshakeRollBackBug(HandshakeRollBackBug);
        }
        return tLSConnectionImpl;
    }

    public TLSConnection createServer(SSLSocket sSLSocket, InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable) throws IOException {
        Vector vector = (Vector)this.enabledCipherSuites.clone();
        Vector vector2 = (Vector)this.authenticatedCipherSuites.clone();
        TLSConnectionImpl tLSConnectionImpl = new TLSConnectionImpl(sSLSocket, inputSSLIO, outputSSLIO, serializable, this.sessionDB, new ProtocolVersion(this.getHelloProtocol()), vector, vector2, this.certificateSupport, false, this.exportLimited, this.srvGatedCryptoOn);
        if (this.debugFlag) {
            tLSConnectionImpl.setDebugFlag();
        }
        tLSConnectionImpl.setWriteFragmentLength(this.WRITE_BLOCK_SIZE);
        if (HandshakeRollBackBug) {
            tLSConnectionImpl.setHandshakeRollBackBug(HandshakeRollBackBug);
        }
        return tLSConnectionImpl;
    }

    public TLSConnection createClient(SSLSocket sSLSocket, InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable) throws IOException {
        Vector vector = (Vector)this.enabledCipherSuites.clone();
        Vector vector2 = (Vector)this.authenticatedCipherSuites.clone();
        TLSConnectionImpl tLSConnectionImpl = new TLSConnectionImpl(sSLSocket, inputSSLIO, outputSSLIO, serializable, this.sessionDB, new ProtocolVersion(this.getHelloProtocol()), vector, vector2, this.certificateSupport, true, this.exportLimited, this.srvGatedCryptoOn);
        if (this.debugFlag) {
            tLSConnectionImpl.setDebugFlag();
        }
        tLSConnectionImpl.setWriteFragmentLength(this.WRITE_BLOCK_SIZE);
        if (HandshakeRollBackBug) {
            tLSConnectionImpl.setHandshakeRollBackBug(HandshakeRollBackBug);
        }
        return tLSConnectionImpl;
    }

    public TLSConnection createClient(InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable) {
        Vector vector = (Vector)this.enabledCipherSuites.clone();
        Vector vector2 = (Vector)this.authenticatedCipherSuites.clone();
        TLSConnectionImpl tLSConnectionImpl = new TLSConnectionImpl(inputSSLIO, outputSSLIO, serializable, this.sessionDB, new ProtocolVersion(this.getHelloProtocol()), vector, vector2, this.certificateSupport, true, this.exportLimited, this.srvGatedCryptoOn);
        if (this.debugFlag) {
            tLSConnectionImpl.setDebugFlag();
        }
        tLSConnectionImpl.setWriteFragmentLength(this.WRITE_BLOCK_SIZE);
        if (HandshakeRollBackBug) {
            tLSConnectionImpl.setHandshakeRollBackBug(HandshakeRollBackBug);
        }
        return tLSConnectionImpl;
    }

    public TLSConnection createServer(InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, Serializable serializable) {
        Vector vector = (Vector)this.enabledCipherSuites.clone();
        Vector vector2 = (Vector)this.authenticatedCipherSuites.clone();
        TLSConnectionImpl tLSConnectionImpl = new TLSConnectionImpl(inputSSLIO, outputSSLIO, serializable, this.sessionDB, new ProtocolVersion(this.getHelloProtocol()), vector, vector2, this.certificateSupport, false, this.exportLimited, this.srvGatedCryptoOn);
        if (this.debugFlag) {
            tLSConnectionImpl.setDebugFlag();
        }
        tLSConnectionImpl.setWriteFragmentLength(this.WRITE_BLOCK_SIZE);
        if (HandshakeRollBackBug) {
            tLSConnectionImpl.setHandshakeRollBackBug(HandshakeRollBackBug);
        }
        return tLSConnectionImpl;
    }

    public static synchronized void setX509BasicConstraintBug(boolean bl) {
        certBasicConstBug = bl;
    }

    public static synchronized boolean getX509BasicConstraintBug() {
        return certBasicConstBug;
    }

    public static synchronized void setHandshakeRollBackBug(boolean bl) {
        HandshakeRollBackBug = bl;
    }

    public static synchronized boolean getHandshakeRollBackBug() {
        return HandshakeRollBackBug;
    }

    public static synchronized void setMaxHandshakeMessageLength(int n) throws IllegalArgumentException {
        if (0 >= n || n >= 0x1000000) {
            throw new IllegalArgumentException(Resources.getMessage("281"));
        }
        maxHandshakeMessageSize = n;
        ASN1Type.setMaxObjectLength(maxHandshakeMessageSize);
    }

    public static synchronized int getMaxHandshakeMessageLength() {
        return maxHandshakeMessageSize;
    }

    public synchronized void setDebugFlag() {
        this.debugFlag = true;
    }

    public void setWriteFragmentLength(int n) {
        if (n > 0 && n < 16385) {
            this.WRITE_BLOCK_SIZE = n;
        } else {
            System.out.println(Resources.getMessage("253"));
        }
    }

    public static synchronized void setAcceptEmptyCertRequest(boolean bl) {
        acceptEmptyCertRequest = bl;
    }

    public static synchronized boolean getAcceptEmptyCertRequest() {
        return acceptEmptyCertRequest;
    }

    public static synchronized void setSendEmptyCertRequest(boolean bl) {
        sendEmptyCertRequest = bl;
    }

    public static synchronized boolean getSendEmptyCertRequest() {
        return sendEmptyCertRequest;
    }

    static {
        x509StrictConstraints = false;
        x509NoV1CAs = false;
        CipherSuiteSupport.reset();
    }
}

